function varargout = GUI_2(varargin)
% GUI_2 Application M-file for GUI_2.fig
%   GUI_2, by itself, creates a new GUI_2 or raises the existing
%   singleton*.
%
%   H = GUI_2 returns the handle to a new GUI_2 or the handle to
%   the existing singleton*.
%
%   GUI_2('CALLBACK',hObject,eventData,handles,...) calls the local
%   function named CALLBACK in GUI_2.M with the given input arguments.
%
%   GUI_2('Property','Value',...) creates a new GUI_2 or raises the
%   existing singleton*.  Starting from the left, property value pairs are
%   applied to the GUI before GUI_2_OpeningFunction gets called.  An
%   unrecognized property name or invalid value makes property application
%   stop.  All inputs are passed to GUI_2_OpeningFcn via varargin.
%
%   *See GUI Options - GUI allows only one instance to run (singleton).
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Copyright 2000-2002 The MathWorks, Inc.

% Edit the above text to modify the response to help GUI_2

% Last Modified by GUIDE v2.5 21-May-2007 09:28:16

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',          mfilename, ...
                   'gui_Singleton',     gui_Singleton, ...
                   'gui_OpeningFcn',    @GUI_2_OpeningFcn, ...
                   'gui_OutputFcn',     @GUI_2_OutputFcn, ...
                   'gui_LayoutFcn',     [], ...
                   'gui_Callback',      []);
if nargin & isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    varargout{1:nargout} = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before GUI_2 is made visible.
function GUI_2_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to GUI_2 (see VARARGIN)

% Choose default command line output for GUI_2

global dir_info

handles.output = hObject;
handles.modified = 0;

% default_directories

model_dir = fileparts(dir_info.param_dir);

      temp_dir = fullfile(model_dir,'parameters_tmp');
          if exist(temp_dir)
               rmdir(temp_dir,'s');
          end
      mkdir(temp_dir);
      mkdir(fullfile(temp_dir, 'output'));
      mkdir(fullfile(temp_dir,'initial_compound_numbers'));
      mkdir(fullfile(temp_dir,'reaction_constants'));
      cp_files = fullfile(dir_info.param_dir,'*.m');
      cp_dir1 = fullfile(dir_info.param_dir,'initial_compound_numbers');
      cp_dir2 = fullfile(dir_info.param_dir,'reaction_constants');
      copyfile(cp_files ,temp_dir);
      copyfile(cp_dir1 ,fullfile(temp_dir,'initial_compound_numbers'));
      copyfile(cp_dir2 ,fullfile(temp_dir,'reaction_constants'));

handles.temp_dir = temp_dir;
if isfield(dir_info, 'output_filename')
    output_filename = dir_info.output_filename;
else
    output_filename = [];
end

if exist(fullfile(temp_dir,'general_constants.m')) && ...
            exist(fullfile(temp_dir,'storing_and_plotting.m'))    
        
        code_dir = dir_info.code_dir;
        param_dir = dir_info.param_dir;
              
        clear plot_info
        clear run_info
        clear general_constants
        clear storing_and_plotting
        
        other_constants
        collect_rundata
        randseed = run_info.randseed;
        
        handles.eventlog_flag = eventlog_flag;
        handles.run_error = run_info.tau_error;
        randstr = num2str(randseed);
        if length(randseed) ~= 1 | length(randstr) > 8
            set(handles.edit_randseed,'String', '');
        else
            set(handles.edit_randseed,'String', num2str(randseed));
        end
        
        set(handles.edit_outfile,'String', dir_info.output_filename);
        set(handles.edit_PlotInt,'String', plot_info.plot_interval);
        set(handles.edit_Scaling,'String', scaling_factor);
        set(handles.edit_snapshot,'String', plot_info.snapshot_interval);
        set(handles.edit_StartTime,'String', run_info.time_start);
        set(handles.edit_EndTime,'String', run_info.time_end);
        set(handles.edit_NumRuns,'String', run_info.num_runs);
        set(handles.edit_Volume,'String',volume0);
        set(handles.menu_Algorithm,'Value', stoch_algor);
        if (stoch_algor == 3)
            set(handles.edit_error, 'Enable', 'on');
            set(handles.edit_error, 'String', run_info.tau_error);
            set(handles.text_error, 'Enable', 'on');
        else
            set(handles.edit_error, 'Enable', 'off');
            set(handles.edit_error, 'String', '');
            set(handles.text_error, 'Enable', 'off');
        end
        
        
        if (plot_info.plot_interval == -1)
            set(handles.checkbox_Plotoff, 'Value',get(handles.checkbox_Plotoff, 'Max'))
        else
            set(handles.checkbox_Plotoff, 'Value',get(handles.checkbox_Plotoff, 'Min'))
        end
        
        if (handles.eventlog_flag == 1)
            set(handles.checkbox_SaveEvlog, 'Value',get(handles.checkbox_SaveEvlog, 'Max'))
        else
            set(handles.checkbox_SaveEvlog, 'Value',get(handles.checkbox_SaveEvlog, 'Min'))
        end
        
end

set(handles.ButtonOK, 'Enable', 'off');
 
% Update handles structure
guidata(hObject, handles);

% Return figure handle as first output argument
    
% UIWAIT makes GUI_2 wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = GUI_2_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

% ------------------------------------------------------------
% Callback for list box - open .fig with guide, otherwise use open
% ------------------------------------------------------------
function varargout = listbox_InitNum_Callback(hObject, eventdata, handles)
% hObject    handle to listbox_InitNum (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns listbox_InitNum contents as cell array
%        contents{get(hObject,'Value')} returns selected item from listbox_InitNum

temp_dir = handles.temp_dir;
get(handles.figure1,'SelectionType');
if strcmp(get(handles.figure1,'SelectionType'),'open')
	index_selected = get(handles.listbox_InitNum,'Value');
	file_list = get(handles.listbox_InitNum,'String');	
    file_n = file_list{index_selected};
    filename = fullfile(temp_dir,'initial_compound_numbers',file_n);
    if ispc
		edit(filename)
    else
        comm = ['emacs ',filename, ' &'];
        system(comm);
    end
end

handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');
 
% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function listbox_InitNum_CreateFcn(hObject, eventdata, handles)
% hObject    handle to listbox_InitNum (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background, change
%       'usewhitebg' to 0 to use default.  See ISPC and COMPUTER.

global dir_info

temp_dir = dir_info.param_dir;
init_dir = fullfile(temp_dir,'initial_compound_numbers');
dir_struct = dir(init_dir);
ind = 1;
n_files = size(dir_struct,1);
 for i=3:n_files
     if ~dir_struct(i).isdir 
         handles.file_names{ind} = dir_struct(i).name;
         ind = ind + 1;
     end
 end    

set(hObject,'String',handles.file_names,...
	'Value',1)


usewhitebg = 1;
if usewhitebg
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes during object creation, after setting all properties.
function figure1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Add the current directory to the path, as the pwd might change thru' the
% gui. Remove the directory from the path when gui is closed 
% (See figure1_DeleteFcn)
setappdata(hObject, 'StartPath', pwd);
addpath(pwd);


% --- Executes during object deletion, before destroying properties.
function figure1_DeleteFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Remove the directory added to the path in the figure1_CreateFcn.
if isappdata(hObject, 'StartPath')
    rmpath(getappdata(hObject, 'StartPath'));
end


% --- Executes on selection change in listbox_ReactConst.
function listbox_ReactConst_Callback(hObject, eventdata, handles)
% hObject    handle to listbox_ReactConst (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns listbox_ReactConst contents as cell array
%        contents{get(hObject,'Value')} returns selected item from
%        listbox_ReactConst
temp_dir = handles.temp_dir;
get(handles.figure1,'SelectionType');
if strcmp(get(handles.figure1,'SelectionType'),'open')
	index_selected = get(handles.listbox_ReactConst,'Value');
	file_list = get(handles.listbox_ReactConst,'String');	
    file_n = file_list{index_selected};
    filename = fullfile(temp_dir,'reaction_constants',file_n);
        if ispc
		edit(filename)
    else
        comm = ['emacs ',filename, ' &'];
        system(comm);
        end
end

handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');
 
% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function listbox_ReactConst_CreateFcn(hObject, eventdata, handles)
% hObject    handle to listbox_ReactConst (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.

global dir_info

temp_dir = dir_info.param_dir;

init_dir = fullfile(temp_dir,'reaction_constants');
dir_struct = dir(init_dir);
ind = 1;
n_files = size(dir_struct,1);
 for i=3:n_files
     if ~dir_struct(i).isdir 
         handles.file_names{ind} = dir_struct(i).name;
         ind = ind + 1;
     end
 end    

set(hObject,'String',handles.file_names,...
	'Value',1)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in menu_Algorithm.
function menu_Algorithm_Callback(hObject, eventdata, handles)
% hObject    handle to menu_Algorithm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns menu_Algorithm contents as cell array
%        contents{get(hObject,'Value')} returns selected item from menu_Algorithm

handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');
    
stoch_algor = get(handles.menu_Algorithm,'Value');
         if stoch_algor == 3
            set(handles.edit_error, 'Enable', 'on');
            set(handles.edit_error, 'String', handles.run_error);
            set(handles.text_error, 'Enable', 'on');
        else
            set(handles.edit_error, 'Enable', 'off');
            set(handles.edit_error, 'String', '');
            set(handles.text_error, 'Enable', 'off');
        end
% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function menu_Algorithm_CreateFcn(hObject, eventdata, handles)
% hObject    handle to menu_Algorithm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.

% Algorithm

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit_Scaling_Callback(hObject, eventdata, handles)
% hObject    handle to edit_Scaling (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_Scaling as text
%        str2double(get(hObject,'String')) returns contents of edit_Scaling as a double


handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function edit_Scaling_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_Scaling (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_Volume_Callback(hObject, eventdata, handles)
% hObject    handle to edit_Volume (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_Volume as text
%        str2double(get(hObject,'String')) returns contents of edit_Volume as a double

handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function edit_Volume_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_Volume (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_randseed_Callback(hObject, eventdata, handles)
% hObject    handle to edit_randseed (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_randseed as text
%        str2double(get(hObject,'String')) returns contents of edit_randseed as a double

handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function edit_randseed_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_randseed (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_outfile_Callback(hObject, eventdata, handles)
% hObject    handle to edit_outfile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_outfile as text
%        str2double(get(hObject,'String')) returns contents of edit_outfile as a double

handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function edit_outfile_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_outfile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_StartTime_Callback(hObject, eventdata, handles)
% hObject    handle to edit_StartTime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_StartTime as text
%        str2double(get(hObject,'String')) returns contents of edit_StartTime as a double

handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function edit_StartTime_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_StartTime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_EndTime_Callback(hObject, eventdata, handles)
% hObject    handle to edit_EndTime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_EndTime as text
%        str2double(get(hObject,'String')) returns contents of edit_EndTime as a double

handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function edit_EndTime_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_EndTime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_NumRuns_Callback(hObject, eventdata, handles)
% hObject    handle to edit_NumRuns (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_NumRuns as text
%        str2double(get(hObject,'String')) returns contents of edit_NumRuns as a double

handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function edit_NumRuns_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_NumRuns (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in checkbox_Plotoff.
function checkbox_Plotoff_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_Plotoff (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_Plotoff

if (get(hObject,'Value') == get(hObject,'Max'))
    set(handles.edit_PlotInt,'String','-1');
else
    set(handles.edit_PlotInt,'String',get (handles.edit_EndTime,'String'));
end

handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

% Update handles structure
guidata(hObject, handles);

function edit_PlotInt_Callback(hObject, eventdata, handles)
% hObject    handle to edit_PlotInt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_PlotInt as text
%        str2double(get(hObject,'String')) returns contents of edit_PlotInt as a double

handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function edit_PlotInt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_PlotInt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in button_PlotDetails.
function button_PlotDetails_Callback(hObject, eventdata, handles)
% hObject    handle to button_PlotDetails (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

temp_dir = handles.temp_dir;
GUI_plot(temp_dir);

handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

% Update handles structure
guidata(hObject, handles);

% --- Executes on button press in checkbox_SaveEvlog.
function checkbox_SaveEvlog_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_SaveEvlog (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_SaveEvlog

if (get(hObject,'Value') == get(hObject,'Max'))
         handles.eventlog_flag = 1;
else
         handles.eventlog_flag = 0;
end
     

handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

% Update handles structure
guidata(hObject, handles);

function edit_snapshot_Callback(hObject, eventdata, handles)
% hObject    handle to edit_snapshot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_snapshot as text
%        str2double(get(hObject,'String')) returns contents of edit_snapshot as a double

handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function edit_snapshot_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_snapshot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in ButtonOK.
function ButtonOK_Callback(hObject, eventdata, handles)
% hObject    handle to ButtonOK (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global SAVE_str
global dir_info
            
temp_dir = handles.temp_dir;   

if (handles.modified == 1)
                       
            GUI_4;
            uiwait(GUI_4);     
            
            if (isempty(SAVE_str) == 0)
                
            save_constants(handles);
               
            param_dir = fullfile(fileparts(temp_dir),SAVE_str);
            dir_info.param_dir = param_dir;            
            output_filename = get(handles.edit_outfile,'String');
            dir_info.output_filename = output_filename;
            dir_info.output_dir = fullfile (dir_info.param_dir, 'output');
            output_file = fullfile(dir_info.output_dir, output_filename);
            dir_info.output_file = output_file;
            
        if exist(param_dir) > 0
            cp_files = fullfile(temp_dir,'*.m');
            cp_dir1 = fullfile(temp_dir,'initial_compound_numbers');
            cp_dir2 = fullfile(temp_dir,'reaction_constants');
            copyfile(cp_files ,param_dir);
            copyfile(cp_dir1 ,fullfile(param_dir,'initial_compound_numbers'));
            copyfile(cp_dir2 ,fullfile(param_dir,'reaction_constants'));
            rmdir(temp_dir,'s');
        else
            movefile(temp_dir,param_dir);
        end
    
        delete(handles.figure1)
        end
else 
    if exist(temp_dir) 
               rmdir(temp_dir,'s')
    end
     delete(handles.figure1)     
end       
       
% --- Executes on button press in ButtonCancel.
function ButtonCancel_Callback(hObject, eventdata, handles)
% hObject    handle to ButtonCancel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

temp_dir = handles.temp_dir;   

   if exist(temp_dir)
        rmdir(temp_dir,'s')
   end
 delete(handles.figure1)

%***************   Functions    *****************************

% Save parameters into the general_constants.m file

function save_constants(handles)
%set data for MODEL (edit1) and PARAMETER (popupmenu1)lists


    dir = pwd;
    temp_dir = handles.temp_dir;
    
    cd(temp_dir);
    general_constants
    cd(dir);
    
    scaling_factor = str2num(get(handles.edit_Scaling,'String'));
    volume0 = str2num(get(handles.edit_Volume,'String'));
    output_filename = get(handles.edit_outfile,'String');
    plot_info.snapshot_interval = str2num(get(handles.edit_snapshot,'String'));
    run_info.time_start = str2num(get(handles.edit_StartTime,'String'));
    run_info.time_end = str2num(get(handles.edit_EndTime,'String'));
    run_info.num_runs = str2num(get(handles.edit_NumRuns,'String'));
    str = get(handles.edit_PlotInt,'String');
    if isempty(str)
        plot_info.plot_interval = -1;
    else
        plot_info.plot_interval =  str2num(str);
    end
    
 %Save General constants
    
    const_file = fullfile(temp_dir,'general_constants.m');
    
    if exist(const_file) ~= 0
        delete (const_file) ;
    end
     
    fid = fopen(const_file,'w');
    if fid == -1
            errordlg('Cannot open general_constants.m file','Oprn File Error!')
            return
    end
        
    fprintf(fid,'%% Constants file created by bns_GUI     \n\n');
    
    fprintf(fid,'scaling_factor = %d;\n',scaling_factor);
    fprintf(fid,'volume0 = %7.1e; \n',volume0);
    fprintf(fid,'volume = scaling_factor .* volume0; \n');    
    fprintf(fid,'monitor_interval = %d; \n\n',monitor_interval);
    fprintf(fid,'time_start = %d; \n',run_info.time_start);
    fprintf(fid,'time_end = %d; \n',run_info.time_end);
    fprintf(fid,'num_runs = %d; \n\n',run_info.num_runs);
    fprintf(fid,'%% stochastic algorithm. 0 = not stochastic (not implemented yet) \n');
    fprintf(fid,'%% 1 = Foy (should be exactly the same as Gillespie, but implemented a bit differently, \n');
    fprintf(fid,'%% 2 = Gillespie original, 3 = Tau-leaping \n\n');
    
    stoch_algor = get(handles.menu_Algorithm,'Value');
    fprintf(fid,'stoch_algor = %d; \n',stoch_algor);
    if (stoch_algor ==3)
            tau_error = get(handles.edit_error, 'String');
        if ~isempty(tau_error)
        fprintf(fid,'tau_error = %d; \n',str2num(tau_error));
        end
    end
  
% moved this section here, bdf
    randinp = get(handles.edit_randseed,'String');
    if ~isempty(randinp)
        fprintf(fid,'randseed = %d; \n',str2num(randinp));
    else
        fprintf(fid,'randseed = []; \n');
    end

    fclose(fid);

 % Save plot_interval
 
    plot_file = fullfile(temp_dir,'storing_and_plotting.m');
    temp_file = fullfile(temp_dir,'plot.tmp');
    
    fout = fopen(temp_file,'w');
  if fout == -1
            errordlg('Cannot open plot.tmp file','Open File Error!')
            return
    end
        
    fin = fopen(plot_file);
    if fin == -1
            errordlg('Cannot open storing_and_plotting.m file','Open File Error!')
            return
    end
    a = fgets(fin); 

       while (a ~= -1)
            if strncmp(a,'plot_interval',13) == 1
                 a = sprintf('plot_interval = %d;\n',plot_info.plot_interval);
            end

% created this here, bdf
            if strncmp(a,'eventlog_flag',13) == 1
                 a = sprintf('eventlog_flag = %d; \n',handles.eventlog_flag);
            end
% save snapshot interval  here, slava
            if strncmp(a,'snapshot_interval',17) == 1
                 a = sprintf('snapshot_interval = %d; \n',plot_info.snapshot_interval);
            end
 % Remove old output_filename if exist, slava
            if strncmp(a,'output_filename',15) == 1
               a = fgets(fin);
               continue
            end
                     
         fprintf(fout,'%s',a);    
         a = fgets(fin);
       end   
           fprintf(fout,'output_filename = ''%s''; \n',output_filename);
           
   fclose(fin);
   fclose(fout);
   
   movefile(temp_file,plot_file);
   

function edit_error_Callback(hObject, eventdata, handles)
% hObject    handle to edit_error (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_error as text
%        str2double(get(hObject,'String')) returns contents of edit_error as a double

handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function edit_error_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_error (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


