function varargout = GUI_text(varargin)
% GUI_TEXT M-file for GUI_text.fig
%      GUI_TEXT, by itself, creates a new GUI_TEXT or raises the existing
%      singleton*.
%
%      H = GUI_TEXT returns the handle to a new GUI_TEXT or the handle to
%      the existing singleton*.
%
%      GUI_TEXT('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in GUI_TEXT.M with the given input arguments.
%
%      GUI_TEXT('Property','Value',...) creates a new GUI_TEXT or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before GUI_text_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to GUI_text_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help GUI_text

% Last Modified by GUIDE v2.5 28-Sep-2006 16:16:26

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @GUI_text_OpeningFcn, ...
                   'gui_OutputFcn',  @GUI_text_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin & isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

  
% --- Executes just before GUI_text is made visible.
function GUI_text_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to GUI_text (see VARARGIN)

% Choose default command line output for GUI_text
handles.output = hObject;



% Update handles structure
guidata(hObject, handles);

% UIWAIT makes GUI_text wait for user response (see UIRESUME)
% uiwait(handles.figure1);
global dir_info
global PLOT_info
global LIST

% retrieve input arguments
param_dir = dir_info.param_dir;
handles.param_dir = param_dir;

% Populate the listbox 

model_dir = fileparts(param_dir);
code_dir = dir_info.code_dir;
output_filename = dir_info.output_filename;

    other_constants
    collect_rundata

%    Modified to work with SBML files    -    Slava Chushak    
%                                             12/19/05
%    Look for *.mat files in the rxns_dir    
    file_list = dir(param_dir);
% If exist *.mat file, check whether it is an SBML model fiel    
    use_sbml = 0;   
    clear model
    for i = 1:size(file_list,1)
        file_name = file_list(i).name;
        if ~isempty(strfind(file_name,'.xml'))
            file_name = fullfile(param_dir,file_name);
            model = TranslateSBML(file_name);
            if isfield(model,'typecode')
                use_sbml = 1;
                break;
            end
        end
    end
    if use_sbml ==1
         n_cmpds =  size(model.species,2);
            
     
            for i = 1:n_cmpds
                if (model.SBML_level == 1)
                    name = model.species(i).name;
                else
                    if (isempty(model.species(i).name))
                        name = model.species(i).id;
                    else
                        name = model.species(i).name;
                    end;
                end
              LIST{i} = name;
            end
            clear model
    else
              
        read_cmpds

        n_cmpds = length(cmpd_list);
 
        for  i=1:n_cmpds
            LIST{i} = cmpd_list{i}{1};
        end 
    end
 
set(handles.listbox1, 'String', LIST, 'Value', 1);

% Update handles structure
guidata(hObject, handles);

% --- Outputs from this function are returned to the command line.
function varargout = GUI_text_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% OK button
%  For multiple compounds, names schould be separated by commas !!!
%
global TEXT
global LIST

TEXT = [];
str = [];
str = get(handles.edit1, 'String');

if isempty(str)
    warndlg('Output string is empty. To cancel - click Exit','Input Argument Error!')
     return
else if ~strcmpi(str,'all') 
%
% Check the string against the names of compounds in cmpd_list
%

%
% In case of several compounts - tokenize the string
% IMPORTANT - name of compounds in the string should be separated by comma
%
  
  n_cmpds = length(LIST);
  rem = str;
  
  while true
     if isempty(rem)
          break;
      end

   [name, rem] = strtok(rem, ',');
   name_found = 0;   
   for  i=1:n_cmpds
       if strcmpi(LIST{i}, name)
           name_found = 1;
         break;
       end
   end 
   

   if (name_found == 0)
          warndlg('Invalid compound name','Input Argument Error!')
     return;
    end 
  end
    end
end
    TEXT = str;
    delete(handles.figure1);
    
    
% --- Executes on button press in pushbutton2.
function pushbutton2_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

delete(handles.figure1);

% --- Executes during object creation, after setting all properties.
function edit1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit1_Callback(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit1 as text
%        str2double(get(hObject,'String')) returns contents of edit1 as a double


% --- Executes on selection change in listbox1.
function listbox1_Callback(hObject, eventdata, handles)
% hObject    handle to listbox1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns listbox1 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from listbox1

global LIST
index = get(handles.listbox1, 'Value');

str = get(handles.edit1, 'String');
if isempty(str)
    set(handles.edit1,'String', LIST{index});
else if strcmpi('all', str)
     errordlg('You already selected ALL compounds. To unselect - click Reset','Input Argument Error');
     return
else
    str =strcat(str, ',', LIST{index});
    set(handles.edit1,'String', str);
    end
end


% --- Executes during object creation, after setting all properties.
function listbox1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to listbox1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes on button press in pushbutton3.
function pushbutton3_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

set(handles.edit1, 'String', 'ALL');

% --- Executes on button press in pushbutton4.
function pushbutton4_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

set(handles.edit1, 'String', '');


% --- Executes during object creation, after setting all properties.
function figure1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called


% --- Executes during object deletion, before destroying properties.
function figure1_DeleteFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


