function varargout = CheckValues(varargin)
% CheckValues Application M-file for CheckValues.fig
%   CheckValues, by itself, creates a new CheckValues or raises the existing
%   singleton*.
%
%   H = CheckValues returns the handle to a new CheckValues or the handle to
%   the existing singleton*.
%
%   CheckValues('CALLBACK',hObject,eventData,handles,...) calls the local
%   function named CALLBACK in CheckValues.M with the given input arguments.
%
%   CheckValues('Property','Value',...) creates a new CheckValues or raises the
%   existing singleton*.  Starting from the left, property value pairs are
%   applied to the GUI before CheckValues_OpeningFunction gets called.  An
%   unrecognized property name or invalid value makes property application
%   stop.  All inputs are passed to CheckValues_OpeningFcn via varargin.
%
%   *See GUI Options - GUI allows only one instance to run (singleton).
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Copyright 2000-2002 The MathWorks, Inc.

% Edit the above text to modify the response to help CheckValues

% Last Modified by GUIDE v2.5 21-May-2007 08:41:36

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',          mfilename, ...
                   'gui_Singleton',     gui_Singleton, ...
                   'gui_OpeningFcn',    @CheckValues_OpeningFcn, ...
                   'gui_OutputFcn',     @CheckValues_OutputFcn, ...
                   'gui_LayoutFcn',     [], ...
                   'gui_Callback',      []);
if nargin & isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    varargout{1:nargout} = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before CheckValues is made visible.
function CheckValues_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to CheckValues (see VARARGIN)

% Choose default command line output for CheckValues
handles.output = hObject;
% retrieve input arguments

global dir_info

clear SBMLmodel
clear TranslateSBML

handles.output = hObject;
handles.modified = 0;

    param_dir = dir_info.param_dir;
    file_list = dir(param_dir);
    
    handles.isSBML = 0;
    handles.SBML_Model = [];
    handles.sbml_file = [];
    
  for i = 1:size(file_list,1)
        file_name = file_list(i).name;
        if ~isempty(strfind(file_name,'.xml'))
            full_name = fullfile(param_dir,file_name);
            test = TranslateSBML(full_name);
            if isSBML_Model(test)
                handles.isSBML = 1;
                handles.SBML_Model = test;
                handles.sbml_file = file_name;  
                break;
            end
        end
  end
    
model_dir = fileparts(dir_info.param_dir);
  temp_dir = fullfile(model_dir,'parameters_tmp');
          if exist(temp_dir)
               rmdir(temp_dir,'s');
          end
          
      mkdir(temp_dir);
      mkdir(fullfile(temp_dir, 'output'));
      copyfile(fullfile(dir_info.param_dir,'*.m'),temp_dir);
      copyfile(fullfile(dir_info.param_dir,'*.xml'),temp_dir);

handles.temp_dir = temp_dir;

SBMLModel = handles.SBML_Model;

[Species, SpeciesValues] = GetSpecies(SBMLModel);
[Parameter, ParameterValues] = GetParameters(SBMLModel);

% keep a copy of initial values
handles.InitialSpeciesValues = SpeciesValues;
handles.InitialParameterValues = ParameterValues;

handles.SpeciesValues = SpeciesValues;
handles.ParameterValues = ParameterValues;

handles.Species = Species;
handles.Parameter = Parameter;

% populate listboxes
NumSpecies = length(SpeciesValues);
for i = 1:NumSpecies
    ListSp(i) = Species(i);
end;

NumParams = length(ParameterValues);
for i = 1:NumParams
    ListParam(i) = Parameter(i);
end;

if (SBMLModel.SBML_level == 1) 
    [x,NumReactions] = size(SBMLModel.reaction);
    for i = 1:NumReactions
        ReactList{i} = SBMLModel.reaction(i).name;
    end;
    if (NumReactions == 0)
        ReactList{1} = 'NO REACTIONS';
    end;
else
    [x,NumReactions] = size(SBMLModel.reaction);
    for i = 1:NumReactions
        % use id unless is empty then use name
        if (isempty(SBMLModel.reaction(i).id))
            ReactList{i} = SBMLModel.reaction(i).name;
        else
            ReactList{i} = SBMLModel.reaction(i).id;
        end;
    end;
    if (NumReactions == 0)
        ReactList{1} = 'NO REACTIONS';
    end;
end

set(handles.ListSpecies, 'String', ListSp);
set(handles.ListParameter, 'String', ListParam);
set(handles.ListReactions, 'String', ReactList);
handles.SpeciesIndex = 1;
handles.ParameterIndex = 1;
handles.ReactionIndex = 1;

set(handles.EditSpeciesAmount, 'String', num2str(handles.SpeciesValues(handles.SpeciesIndex),6));
set(handles.EditParameterValue, 'String', num2str(handles.ParameterValues(handles.ParameterIndex),6));

handles.Model = SBMLModel;

handles.ParamArray = WriteNegativeParameterConfimationArray(handles);

if isfield(dir_info,'output_filename')
    output_filename = dir_info.output_filename;
else
    output_fulename = [];
end

if exist(fullfile(temp_dir,'general_constants.m')) && ...
            exist(fullfile(temp_dir,'storing_and_plotting.m'))    
        
        code_dir = dir_info.code_dir;
        param_dir = dir_info.param_dir;

        clear plot_info
        clear run_info
        clear general_constants
        clear storing_and_plotting

        other_constants
        collect_rundata
        randseed = run_info.randseed;
 
        handles.eventlog_flag = eventlog_flag;
       handles.run_error = run_info.tau_error;
        randstr = num2str(randseed);
        if length(randseed) ~= 1 | length(randstr) > 8
            set(handles.edit_randseed,'String', '');
        else
            set(handles.edit_randseed,'String', num2str(randseed));
        end
        
        set(handles.edit_outfile,'String', dir_info.output_filename);
        set(handles.edit_PlotInt,'String', plot_info.plot_interval);
        set(handles.edit_snapshot,'String', plot_info.snapshot_interval);
        set(handles.edit_StartTime,'String', run_info.time_start);
        set(handles.edit_EndTime,'String', run_info.time_end);
        set(handles.edit_NumRuns,'String', run_info.num_runs);        
        set(handles.menu_Algorithm,'Value', stoch_algor);
        if (stoch_algor == 3)
            set(handles.edit_error, 'Enable', 'on');
            set(handles.edit_error, 'String', run_info.tau_error);
            set(handles.text_error, 'Enable', 'on');
        else
            set(handles.edit_error, 'Enable', 'off');
            set(handles.edit_error, 'String', '');
            set(handles.text_error, 'Enable', 'off');
        end

        if (plot_info.plot_interval == -1)
            set(handles.checkbox_Plotoff, 'Value',get(handles.checkbox_Plotoff, 'Max'))
        else
            set(handles.checkbox_Plotoff, 'Value',get(handles.checkbox_Plotoff, 'Min'))
        end
        
        if (handles.eventlog_flag == 1)
            set(handles.checkbox_SaveEvlog, 'Value',get(handles.checkbox_SaveEvlog, 'Max'))
        else
            set(handles.checkbox_SaveEvlog, 'Value',get(handles.checkbox_SaveEvlog, 'Min'))
        end
end

set(handles.ButtonOK, 'Enable', 'off');

% Update handles structure
guidata(hObject, handles);
% Return figure handle as first output argument
    
% UIWAIT makes CheckValues wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = CheckValues_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes during object creation, after setting all properties.
function figure1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Add the current directory to the path, as the pwd might change thru' the
% gui. Remove the directory from the path when gui is closed 
% (See figure1_DeleteFcn)
setappdata(hObject, 'StartPath', pwd);
addpath(pwd);


% --- Executes during object deletion, before destroying properties.
function figure1_DeleteFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Remove the directory added to the path in the figure1_CreateFcn.
if isappdata(hObject, 'StartPath')
    rmpath(getappdata(hObject, 'StartPath'));
end


% --- Executes on selection change in menu_Algorithm.
function menu_Algorithm_Callback(hObject, eventdata, handles)
% hObject    handle to menu_Algorithm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns menu_Algorithm contents as cell array
%        contents{get(hObject,'Value')} returns selected item from menu_Algorithm

handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');
stoch_algor = get(handles.menu_Algorithm,'Value');
         if stoch_algor == 3
            set(handles.edit_error, 'Enable', 'on');
            set(handles.edit_error, 'String', handles.run_error);
            set(handles.text_error, 'Enable', 'on');
        else
            set(handles.edit_error, 'Enable', 'off');
            set(handles.edit_error, 'String', '');
            set(handles.text_error, 'Enable', 'off');
        end

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function menu_Algorithm_CreateFcn(hObject, eventdata, handles)
% hObject    handle to menu_Algorithm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function edit_randseed_Callback(hObject, eventdata, handles)
% hObject    handle to edit_randseed (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_randseed as text
%        str2double(get(hObject,'String')) returns contents of edit_randseed as a double

handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function edit_randseed_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_randseed (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_outfile_Callback(hObject, eventdata, handles)
% hObject    handle to edit_outfile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_outfile as text
%        str2double(get(hObject,'String')) returns contents of edit_outfile as a double

handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function edit_outfile_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_outfile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_StartTime_Callback(hObject, eventdata, handles)
% hObject    handle to edit_StartTime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_StartTime as text
%        str2double(get(hObject,'String')) returns contents of edit_StartTime as a double

handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function edit_StartTime_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_StartTime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_EndTime_Callback(hObject, eventdata, handles)
% hObject    handle to edit_EndTime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_EndTime as text
%        str2double(get(hObject,'String')) returns contents of edit_EndTime as a double

handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function edit_EndTime_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_EndTime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_NumRuns_Callback(hObject, eventdata, handles)
% hObject    handle to edit_NumRuns (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_NumRuns as text
%        str2double(get(hObject,'String')) returns contents of edit_NumRuns as a double

handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function edit_NumRuns_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_NumRuns (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in checkbox_Plotoff.
function checkbox_Plotoff_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_Plotoff (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_Plotoff

if (get(hObject,'Value') == get(hObject,'Max'))
    set(handles.edit_PlotInt,'String','-1');
else
    set(handles.edit_PlotInt,'String',get (handles.edit_EndTime,'String'));
end
handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

% Update handles structure
guidata(hObject, handles);


function edit_PlotInt_Callback(hObject, eventdata, handles)
% hObject    handle to edit_PlotInt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_PlotInt as text
%        str2double(get(hObject,'String')) returns contents of edit_PlotInt as a double

handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function edit_PlotInt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_PlotInt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in button_PlotDetails.
function button_PlotDetails_Callback(hObject, eventdata, handles)
% hObject    handle to button_PlotDetails (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

temp_dir = handles.temp_dir;
GUI_plot(temp_dir);

handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

% Update handles structure
guidata(hObject, handles);

% --- Executes on button press in checkbox_SaveEvlog.
function checkbox_SaveEvlog_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_SaveEvlog (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_SaveEvlog
if (get(hObject,'Value') == get(hObject,'Max'))
         handles.eventlog_flag = 1;
else
         handles.eventlog_flag = 0;
end
handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

% Update handles structure
guidata(hObject, handles);


function edit_snapshot_Callback(hObject, eventdata, handles)
% hObject    handle to edit_snapshot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_snapshot as text
%        str2double(get(hObject,'String')) returns contents of edit_snapshot as a double

handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function edit_snapshot_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_snapshot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function EditSpeciesAmount_Callback(hObject, eventdata, handles)
% hObject    handle to EditSpeciesAmount (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of EditSpeciesAmount as text
%        str2double(get(hObject,'String')) returns contents of EditSpeciesAmount as a double

SBMLModel = handles.SBML_Model;     
value = str2double(get(handles.EditSpeciesAmount, 'String'));
   
    if isnan(value) || value < 0
        errordlg(' Please, check the entered value','Error in initialAmount');
        return
    else
        handles.SpeciesValues(handles.SpeciesIndex) = value;
        SBMLModel.species(handles.SpeciesIndex).initialAmount = value;
    end

    handles.modified = 1;
    set(handles.ButtonOK, 'Enable', 'on');
   
% Update handles structure
handles.SBML_Model = SBMLModel;

guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function EditSpeciesAmount_CreateFcn(hObject, eventdata, handles)
% hObject    handle to EditSpeciesAmount (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in ListSpecies.
function ListSpecies_Callback(hObject, eventdata, handles)
% hObject    handle to ListSpecies (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns ListSpecies contents as cell array
%        contents{get(hObject,'Value')} returns selected item from ListSpecies

handles.SpeciesIndex = get(handles.ListSpecies, 'Value');
set(handles.EditSpeciesAmount, 'String', num2str(handles.SpeciesValues(handles.SpeciesIndex),6));

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function ListSpecies_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ListSpecies (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function EditParameterValue_Callback(hObject, eventdata, handles)
% hObject    handle to EditParameterValue (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of EditParameterValue as text
%        str2double(get(hObject,'String')) returns contents of EditParameterValue as a double

SBMLModel = handles.SBML_Model;
value = str2double(get(handles.EditParameterValue, 'String'));
   
    if isnan(value) || value < 0
        errordlg(' Please, check the entered value','Error in Parameter Value');
        return
    else
        handles.ParameterValues(handles.ParameterIndex) = value;
        SBMLModel.parameter(handles.SpeciesIndex).value = value;
    end
    
if (handles.ParameterValues(handles.ParameterIndex) < 0)
    handles.ParamArray(handles.ParameterIndex) = 0;
else
    handles.ParamArray(handles.ParameterIndex) = 1;
end;
handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

% Update handles structure
handles.SBML_Model = SBMLModel;

guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function EditParameterValue_CreateFcn(hObject, eventdata, handles)
% hObject    handle to EditParameterValue (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in ListParameter.
function ListParameter_Callback(hObject, eventdata, handles)
% hObject    handle to ListParameter (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns ListParameter contents as cell array
%        contents{get(hObject,'Value')} returns selected item from ListParameter

handles.ParameterIndex = get(handles.ListParameter, 'Value');
set(handles.EditParameterValue, 'String', num2str(handles.ParameterValues(handles.ParameterIndex),6));

% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function ListParameter_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ListParameter (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in ViewReact_button.
function ViewReact_button_Callback(hObject, eventdata, handles)
% hObject    handle to ViewReact_button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


handles.SBML_Model.reaction(handles.ReactionIndex)= ViewReaction(handles.Model.reaction(handles.ReactionIndex));
handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

guidata(hObject, handles);


% --- Executes on selection change in ListReactions.
function ListReactions_Callback(hObject, eventdata, handles)
% hObject    handle to ListReactions (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns ListReactions contents as cell array
%        contents{get(hObject,'Value')} returns selected item from ListReactions

handles.ReactionIndex = get(handles.ListReactions, 'Value');
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function ListReactions_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ListReactions (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in ButtonOK.
function ButtonOK_Callback(hObject, eventdata, handles)
% hObject    handle to ButtonOK (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
global SAVE_str
global dir_info

SBMLModel = handles.SBML_Model;            
temp_dir = handles.temp_dir;   

if (handles.modified == 1)
            
            GUI_4;
            uiwait(GUI_4);
         if (isempty(SAVE_str) ==0)   
            save_constants(handles);
            SpeciesOK = CheckSpeciesValues(handles);
            ParametersOK = CheckParameterValues(hObject, handles);
            file_name = fullfile(temp_dir,handles.sbml_file);
            OutputSBML(SBMLModel,file_name);
               
            param_dir = fullfile(fileparts(temp_dir),SAVE_str);
            dir_info.param_dir = param_dir;
            output_filename = get(handles.edit_outfile,'String');
            dir_info.output_filename = output_filename;
            dir_info.output_dir = fullfile (dir_info.param_dir, 'output');
            output_file = fullfile(dir_info.output_dir, output_filename);
            dir_info.output_file = output_file;
       if exist(param_dir) > 0          
         f_list = fullfile(temp_dir,'*.m');     
        copyfile(f_list,param_dir);
         f_list = fullfile(temp_dir,'*.xml');  
        copyfile(f_list,param_dir)
        rmdir(temp_dir,'s');    
       else
           movefile(temp_dir,param_dir);   
       end    
            delete(handles.figure1)
         end
else
             if exist(temp_dir) 
               rmdir(temp_dir,'s')
             end
         delete(handles.figure1)   
end
       
% --- Executes on button press in ButtonCancel.
function ButtonCancel_Callback(hObject, eventdata, handles)
% hObject    handle to ButtonCancel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

temp_dir = handles.temp_dir;   

   if exist(temp_dir)
        rmdir(temp_dir,'s')
   end
 delete(handles.figure1)


%***********   Functions    ***********************************


function y = CheckSpeciesValues(handles)

y = 0;
% check that concentrations have been set
if (ismember(-1, handles.SpeciesValues))
    msgbox('Not all species values have been set','', 'error');
    y = 1;
    return;
end;

% check for negative concentration values
NegSpecies = 0;
i = 1;
while (i < length(handles.Species))
    if (handles.SpeciesValues(i) < 0)
        NegSpecies = i;
        NegMessage = sprintf('Species %s has negative concentration', handles.Species{i});
        break;
    end;
    i = i+1;
end;

if (NegSpecies ~= 0)
    msgbox(NegMessage,'', 'error');
    y = 1;
    return;
end;

% check that all concentrations are not 0
if (handles.SpeciesValues == 0)
    msgbox('Cannot have all species values set to zero','', 'error');
    y = 1;
    return;
end;

%----------------------------------------------------------------------

function y = CheckParameterValues(hObject, handles)

y = 0;

NoParams = length(handles.Parameter);

% find each unconfirmed value and prompt user for confirmation
for i = 1:NoParams
    if (handles.ParamArray(i) == 0)
        Message = sprintf('Value for parameter %s is %d. Is this correct?', handles.Parameter{i}, handles.ParameterValues(i));
        
        answer = questdlg(Message);
        
        if strcmp(answer, 'Yes')
            handles.ParamArray(i) = 1;
        end;
    end;
end;
   
% save the confirmed 
% Update handles structure
guidata(hObject, handles);

if (sum(handles.ParamArray) ~= NoParams)
    y = 1;
end;

function array = WriteNegativeParameterConfimationArray(handles)
NoParams = length(handles.Parameter);
% get an array showing whether values are negative
for i = 1:NoParams
    if (handles.ParameterValues(i) <= 0)
        array(i) = 0;
    else
        array(i) = 1;
    end;
end;

function save_constants(handles)
%set data for MODEL (edit1) and PARAMETER (popupmenu1)lists

    dir = pwd;
    temp_dir = handles.temp_dir;
    
    cd(temp_dir);
    general_constants
    cd(dir);
    
    output_filename = get(handles.edit_outfile,'String');
    plot_info.snapshot_interval = str2num(get(handles.edit_snapshot,'String'));
    run_info.time_start = str2num(get(handles.edit_StartTime,'String'));
    run_info.time_end = str2num(get(handles.edit_EndTime,'String'));
    run_info.num_runs = str2num(get(handles.edit_NumRuns,'String'));
    str = get(handles.edit_PlotInt,'String');
    if isempty(str)
        plot_info.plot_interval = -1;
    else
        plot_info.plot_interval =  str2num(str);
    end
    
 %Save General constants
    
    const_file = fullfile(temp_dir,'general_constants.m');
    
    if exist(const_file) ~= 0
        delete (const_file) ;
    end
     
    fid = fopen(const_file,'w');
    if fid == -1
            errordlg('Cannot open general_constants.m file','Oprn File Error!')
            return
    end
        
    fprintf(fid,'%% Constants file created by bns_GUI     \n\n');
    fprintf(fid,'scaling_factor = 1;\n');
    fprintf(fid,'volume0 = 5.0e-16; \n');
    fprintf(fid,'volume = scaling_factor .* volume0; \n');       
    fprintf(fid,'monitor_interval = %d; \n\n',monitor_interval);
    fprintf(fid,'time_start = %d; \n',run_info.time_start);
    fprintf(fid,'time_end = %d; \n',run_info.time_end);
    fprintf(fid,'num_runs = %d; \n\n',run_info.num_runs);
    fprintf(fid,'%% stochastic algorithm. 0 = not stochastic (not implemented yet) \n');
    fprintf(fid,'%% 1 = mine (should be exactly the same as gillespie, but implemented a bit differently, \n');
    fprintf(fid,'%% 2 = gillespie original, 3 = gillespie-gibson (not implemented yet) \n\n');
    
        stoch_algor = get(handles.menu_Algorithm,'Value');
    fprintf(fid,'stoch_algor = %d; \n',stoch_algor);
    if (stoch_algor ==3)
            tau_error = get(handles.edit_error, 'String');
        if ~isempty(tau_error)
        fprintf(fid,'tau_error = %d; \n',str2num(tau_error));
        end
    end

% moved this section here, bdf
    randinp = get(handles.edit_randseed,'String');
    if ~isempty(randinp)
        fprintf(fid,'randseed = %d; \n',str2num(randinp));
    else
        fprintf(fid,'randseed = []; \n');
    end

    fclose(fid);

 % Save plot_interval
 
    plot_file = fullfile(temp_dir,'storing_and_plotting.m');
    temp_file = fullfile(temp_dir,'plot.tmp');
    
    fout = fopen(temp_file,'w');
  if fout == -1
            errordlg('Cannot open plot.tmp file','Open File Error!')
            return
    end
        
    fin = fopen(plot_file);
    if fin == -1
            errordlg('Cannot open storing_and_plotting.m file','Open File Error!')
            return
    end
    a = fgets(fin); 

       while (a ~= -1)
            if strncmp(a,'plot_interval',13) == 1
                 a = sprintf('plot_interval = %d;\n',plot_info.plot_interval);
            end

% created this here, bdf
            if strncmp(a,'eventlog_flag',13) == 1
                 a = sprintf('eventlog_flag = %d; \n',handles.eventlog_flag);
            end
% save snapshot interval  here, slava
            if strncmp(a,'snapshot_interval',17) == 1
                 a = sprintf('snapshot_interval = %d; \n',plot_info.snapshot_interval);
            end
 % Remove old output_filename if exist, slava
            if strncmp(a,'output_filename',15) == 1
               a = fgets(fin);
               continue
            end
                     
         fprintf(fout,'%s',a);    
         a = fgets(fin);
       end   
           fprintf(fout,'output_filename = ''%s''; \n',output_filename);
                       
   fclose(fin);
   fclose(fout);
   
   movefile(temp_file,plot_file);



function edit21_Callback(hObject, eventdata, handles)
% hObject    handle to edit_outfile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_outfile as text
%        str2double(get(hObject,'String')) returns contents of edit_outfile as a double


% --- Executes during object creation, after setting all properties.
function edit21_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_outfile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_error_Callback(hObject, eventdata, handles)
% hObject    handle to edit_error (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_error as text
%        str2double(get(hObject,'String')) returns contents of edit_error as a double
handles.modified = 1;
set(handles.ButtonOK, 'Enable', 'on');

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function edit_error_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_error (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


