function varargout = bns_GUI(varargin)

% Created by Slava Chushak  08/2005
%      Modified        09/2006

% BNS_GUI M-file for bns_GUI.fig
%      BNS_GUI, by itself, creates a new BNS_GUI or raises the existing
%      singleton*.
%
%      H = BNS_GUI returns the handle to a new BNS_GUI or the handle to
%      the existing singleton*.
%
%      BNS_GUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in BNS_GUI.M with the given input arguments.
%
%      BNS_GUI('Property','Value',...) creates a new BNS_GUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before bns_GUI_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to bns_GUI_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help bns_GUI

% Last Modified by GUIDE v2.5 27-Sep-2006 15:25:31

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @bns_GUI_OpeningFcn, ...
                   'gui_OutputFcn',  @bns_GUI_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before bns_GUI is made visible.
function bns_GUI_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to bns_GUI (see VARARGIN)

global dir_info

% Choose default command line output for bns_GUI
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

dir_info = varargin{2};
%randseed = varargin{3};


%handles.event_log_flag = dir_info.event_log_flag;
parameter_sets = dir_info.parameter_sets;

% set the initial model directory

rxns_dir = dir_info.rxns_dir;
[path_str, dir_str] = fileparts(rxns_dir);
set(handles.edit1,'String', dir_str);

% set the initial parameters popup list and parameter values

[path_str, str] = fileparts(dir_info.param_dir);

% Does the param_dir fed to GUI exist under MODELDIR?
dir_struct = dir(rxns_dir);
ind = 1;
val = 0;
n_files=size(dir_struct,1);
for i = 3:n_files 
%    if (dir_struct(i).isdir && strncmp('param', dir_struct(i).name, 5))    
     if dir_struct(i).isdir
         if exist(fullfile(rxns_dir,dir_struct(i).name,'general_constants.m')) && ...
            exist(fullfile(rxns_dir,dir_struct(i).name,'storing_and_plotting.m'))    
            dir_names{ind} = dir_struct(i).name;
            if strcmp(str,dir_names{ind})
                val = ind;
            end
            ind = ind + 1;
        end
    end
end

if ind == 1 | val == 0      % Specified param_dir does not exist under MODELDIR
         set(handles.popupmenu1,'String','No parameters');
    else

        set(handles.popupmenu1,'String',dir_names,...
		'Value',val);
  
    par_dir = fullfile(rxns_dir,dir_names{val});
    file_list = dir(par_dir);
    
        if exist(fullfile(par_dir,[parameter_sets '.m']))
           set(handles.edit_paramsets,'String', parameter_sets);
        else
           set(handles.edit_paramsets,'String', '');
        end
        
end
        set(handles.pushbutton7, 'Enable', 'off');
%        if ispc
%          set(handles.popupmenu2, 'Enable', 'off');
%        end
        
        
% Update handles structure
guidata(hObject, handles);

% UIWAIT makes bns_GUI wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = bns_GUI_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


function edit1_Callback(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit1 as text
%        str2double(get(hObject,'String')) returns contents of edit1 as a double


% --- Executes during object creation, after setting all properties.
function edit1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.init_dir= pwd;

%   Current "MODEL"  directory

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenu1.
function popupmenu1_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu1 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu1

%  Set "PARAMETERS" directory
global dir_info
    par_index = get(handles.popupmenu1, 'Value');
    par_list = get(handles.popupmenu1, 'String');
    
if strcmp(par_list, 'No parameters')
    errordlg('There in no parameters file in the MODEL directory','Input Argument Error!')
        return
end 

param_dir = fullfile(dir_info.rxns_dir,par_list{par_index});
dir_info.param_dir = param_dir;
    output_directory = 'output';
    dir_info.output_dir = fullfile(param_dir,output_directory);

guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function popupmenu1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
% Set popupmenu1 "PARAMETERS"

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton4.
function pushbutton4_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%  "Details" of parameters button

global dir_info

    par_index = get(handles.popupmenu1,'Value');
    par_list = get(handles.popupmenu1,'String');
 
if strcmp(par_list, 'No parameters')
     errordlg('There is no parameters directory in the chosen model directory','Input Argument Error!')
     return
else

     handles.isSBML = 0;

     file_list = dir(dir_info.param_dir);
     
    for i = 1:size(file_list,1)
        file_name = file_list(i).name;
        if ~isempty(strfind(file_name,'.xml'))
            full_name = fullfile(dir_info.param_dir,file_name);
            test = TranslateSBML(full_name);
            if isSBML_Model(test)
                handles.isSBML = 1;
                break;
            end
        end
    end
    
    if (handles.isSBML == 1)
       CheckValues;
       uiwait(CheckValues);
    else
       GUI_2;
       uiwait(GUI_2);
    end
    
    rxns_dir = dir_info.rxns_dir;
    dir_struct = dir(rxns_dir);
    [path str] = fileparts(dir_info.param_dir);
    ind = 1;
    val = 0;
    n_files=size(dir_struct,1);
  for i = 3:n_files 
     if dir_struct(i).isdir
         if exist(fullfile(rxns_dir,dir_struct(i).name,'general_constants.m')) && ...
            exist(fullfile(rxns_dir,dir_struct(i).name,'storing_and_plotting.m'))    
            dir_names{ind} = dir_struct(i).name;
            if strcmp(str,dir_names{ind})
                val = ind;
            end
            ind = ind + 1;
        end
     end
  end

  if ind == 1 | val == 0      % Specified param_dir does not exist under MODELDIR
         set(handles.popupmenu1,'String','No parameters');
    else

        set(handles.popupmenu1,'String',dir_names,...
		'Value',val);
  end

end

    guidata(hObject, handles);
    
    
% --- Executes on button press in pushbutton6.
function pushbutton6_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% "Run" simulations


global dir_info
global BATCH

    par_index = get(handles.popupmenu1, 'Value');
    par_list = get(handles.popupmenu1, 'String');
    
if strcmp(par_list, 'No parameters')
    errordlg('There in no parameters file in the MODEL directory','Input Argument Error!')
        return
end 

code_dir = dir_info.code_dir;
models_dir = dir_info.models_dir;
rxns_dir = dir_info.rxns_dir;
param_dir = dir_info.param_dir;
output_dir = dir_info.output_dir;

if exist(output_dir) == 0
    mkdir(output_dir);
end


parameter_sets = get(handles.edit_paramsets,'String');
dir_info.parameter_sets = parameter_sets;

clear_stuff
clear other_constants 


other_constants 
collect_rundata
output_filename = dir_info.output_filename;

% the line below, 'if isempty(randseed)', causes an error if randseed has not previously
% been defined as a variable, since matlab assumes randseed is then a function, at least on some installations
% of matlab (randseed *is* a function in the communications toolbox).  Therefore, the following
% 'if' block forces randseed to be defined as a variable.
% Note that this error occurs *before* matlab executes the 'other_constants' command above (which would generally assign
% randseed to be a variable).  This whole file in fact is never executed.  Matlab is "looking ahead"
% and sees this problem with the randseed's type (variable vs. function conflict) and flags the whole file as containing
% a fatal error.
if (exist('randseed') ~= 1)
    randseed = [];
end

if isempty(randseed)
    temclock = sum(fix(clock));
    randseed = temclock;
end
run_info.randseed = randseed; 

partname = [output_filename '*'];
delete(fullfile(output_dir, partname ));


    handles.isSBML = 0;
    handles.SBML_Model = [];
    handles.sbml_file = [];
    file_list = dir(param_dir);

    for i = 1:size(file_list,1)
        file_name = file_list(i).name;
        if ~isempty(strfind(file_name,'.xml'))
            full_name = fullfile(param_dir,file_name);
            test = TranslateSBML(full_name);
            if isSBML_Model(test)
                handles.isSBML = 1;
                handles.SBML_Model = test;
                handles.sbml_file = file_name;  
                break;
            end
        end
    end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% batch mode section
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
run_index = get(handles.popupmenu2, 'Value');
run_list = get(handles.popupmenu2, 'String');
 
if strcmpi(run_list{run_index},'batch')  % Run in the batch mode    
% Mofidy the default_directories.m    
   
    save_defaults(handles); 
    
    if ispc
        use_batch = 1;
        usebatch
    else
    batch_host = getenv('HOST');       
    if strcmp(batch_host, 'hpc11-0')
       batch_file = hpc11_batch(dir_info, BATCH);
    else
        if strcmp(batch_host, 'jvn-l1')
           batch_file = jvn_batch(dir_info, BATCH);
        else
                if strncmp(batch_host, 'falcon',6)
                batch_file = falcon_batch(dir_info, BATCH);
        else
                batch_file = create_batch_script(dir_info, BATCH);
        return 
        end
     end
    end

  comm = ['bsub < ',batch_file, ' &'];
  system(comm);
  warndlg(' Batch job has been submitted ...','GUI_batch message');
      end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% non-batch mode section
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
else    % not batch mode
    tic     
    disp('Job is running... Please, be patient');

    run_id = 0;
    
exec_file = fullfile(output_dir, [output_filename '_timesexecuted']);
fid_exec = fopen(exec_file,'wt');

%    Modified to work with SBML files    -    Slava Chushak    

        if (handles.isSBML == 1)
            use_sbml = 1;
            sbml_model = handles.SBML_Model;
            [rxn_grp, cmpd_info] = read_sbml_model(sbml_model);
            for i = 1:length(plot_info.monitor_cmpds)
                found_gid = 0;
                for j = 1:cmpd_info.num_cmpds
                    if strcmp(plot_info.monitor_cmpds{i},cmpd_info.cmpd_name{j})
                        plot_info.monitor_cmpds_gid(i) = j;
                        found_gid = 1;
                        break;
                    end
                end
             % Additional check for SBML Level2
                if (found_gid == 0) && (sbml_model.SBML_level == 2)
                    for j = 1:cmpd_info.num_cmpds
                        if strcmp(plot_info.monitor_cmpds{i},sbml_model.species(1,j).name)
                            plot_info.monitor_cmpds_gid(i) = j;
                            found_gid = 1;
                            break;
                        end
                    end
                end
                if found_gid == 0
                    error([ 'Cannot find gid for plot_info.monitor_cmpds - '  plot_info.monitor_cmpds{i}]);
                end
            end
            for i = 1:length(plot_info.monitor_cmpds_gid)
                rxn_grp{1}.monitor_comps(i) = find(plot_info.monitor_cmpds_gid(i) == rxn_grp{1}.global_comp_gid);
            end
        
     curr_dir = pwd;
     cd ('bns_mat_c');
        mex_makefile
     cd (curr_dir);   

        num_rxns = length(rxn_grp{1}.rxn);
               % Save initial kinetic constants
              for i_rxn = 1: num_rxns
               rxn = rxn_grp{1}.rxn{i_rxn};
               StoP{i_rxn} = rxn.StoP;
              end
 
        else    % not sbml
        	read_cmpds
        	read_reactions
        	read_reaction_constants
        	prepare_rxn_grps	
            StoP = [];
            use_sbml = 0;
        end
        num_cmpds = cmpd_info.num_cmpds;
        orig_cmpd_vals = cmpd_info.orig_cmpd_vals;
        num_grps = length(rxn_grp);
        dir_info.use_sbml = use_sbml;
        
    for i_setnum = 1:numsets  
        if use_paramset
            thisset = pset(i_setnum);

            [cmpd_info, rxn_grp] = update_parameters(thisset, orig_cmpd_vals, num_cmpds, cmpd_info, scaling_factor, use_sbml, num_rxns, rxn_grp, StoP);

            if isfield(thisset,'newrateparms')
                if use_sbml ~= 1  
                % Not sbml
                    read_reactions
                    read_reaction_constants
                    prepare_rxn_grps   
                end
            end % newrateparms
       
            if isfield(thisset,'numruns')
                num_repeats = thisset.numruns;
            end
        end
    
        init_plots
        plot_info.mpi_save_param = 0;
        
        rxn_grp{1}.cmpd_nums = create_cmpd_matrix(rxn_grp{1}.global_comp_gid, cmpd_info);
        [modrxn, moddepend, mod_monitor] = prepare_matlab_indices_for_c(rxn_grp{1}.rxn, rxn_grp{1}.rxn_dependency_matrix, rxn_grp{1}.monitor_comps);
        write_bns_textfile(modrxn,rxn_grp{1}.cmpd_nums(:,1), mod_monitor, run_info, plot_info, dir_info, numsets);
        movefile([output_filename '_constants.txt'], output_dir);
	
    save_rundata(output_dir, output_filename, plot_info, 'plot_info', run_info, 'run_info', dir_info, 'dir_info', cmpd_info, 'cmpd_info', rxn_grp, 'rxn_grp');
    
        for i_repeat_num = 1:num_repeats
        
            run_id = run_id + 1;
            
            if run_id == 1  % only seed the random number generator for first simulation
                run_info.use_randseed = 1;
            else
                run_info.use_randseed = 0;
            end

            rxn_grp = runsim(cmpd_info, plot_info, run_info, dir_info, rxn_grp, run_id);
  
    % save to disk the number of times each reaction was executed 
       for i = 1:num_grps
         save_timesexecuted(fid_exec, i, i_setnum,  run_id, rxn_grp{i}.times_rxns_executed);
       end

        end     %num_repeats
    end     % numsets

    if plot_interval ~= -2
        bns_plot(output_dir, output_filename);
    end
    fclose(fid_exec);

    real_time_elapsed = toc


end     % non-batch mode


% --- Executes on button press in pushbutton8.
function pushbutton8_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% "Save"

      par_index = get(handles.popupmenu1, 'Value');
      par_list = get(handles.popupmenu1, 'String');
    if strcmp(par_list, 'No parameters')
            errordlg('There in no parameters file in the MODEL directory','Input Argument Error!')
            return
    else      
        save_defaults(handles);
    end
    
  
% --- Executes on button press in pushbutton9.
function pushbutton9_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%  "Exit"

delete(handles.figure1)
%close(bns_GUI);


% --- Executes on button press in pushbutton10.
function pushbutton10_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Set "MODEL" directory button

global dir_info

GUI_1('dir', dir_info.code_dir);
uiwait(GUI_1);

dir_info.rxns_dir = pwd;
cd(dir_info.code_dir);
handles = init_gui_data(dir_info.rxns_dir, handles);

dir_info.output_filename = [];

guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function figure1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Add the current directory to the path, as the pwd might change thru' the
% gui. Remove the directory from the path when gui is closed 
% (See figure1_DeleteFcn)
setappdata(hObject, 'StartPath', pwd);
addpath(pwd);


% --- Executes during object deletion, before destroying properties.
function figure1_DeleteFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Remove the directory added to the path in the figure1_CreateFcn.
if isappdata(hObject, 'StartPath')
    rmpath(getappdata(hObject, 'StartPath'));
end


% --- Executes on button press in pushbutton7.
function pushbutton7_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Batch Details

global BATCH

       GUI_batch_script;
       uiwait(GUI_batch_script);


% --- Executes on selection change in popupmenu2.
function popupmenu2_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu2 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu2

% Run mode
   global BATCH

   index = get(hObject,'Value');
   list = get(hObject,'String');

   if strcmpi(list{index},'batch') && ~ispc
       set(handles.pushbutton7, 'Enable', 'on');
       GUI_batch_script;
       uiwait(GUI_batch_script);
   else
       set(handles.pushbutton7, 'Enable', 'off'); 
   end
  

function edit_paramsets_Callback(hObject, eventdata, handles)
% hObject    handle to edit_paramsets (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_paramsets as text
%        str2double(get(hObject,'String')) returns contents of edit_paramsets as a double


% --- Executes during object creation, after setting all properties.
function edit_paramsets_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_paramsets (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% ****************   Functions           ****************

% Save model_dir and param_dir into the default_directories.m file
function save_defaults(handles)
%models_dir

    global dir_info
    
    temp_file = 'temp_GUI';
    def_file = 'default_directories.m';
     
%    default_directories
    
    fid = fopen(temp_file,'w');
    if fid == -1
            errordlg('Cannot open temp-file','Open File Error!')
            return
    end
    
      par_index = get(handles.popupmenu1, 'Value');
      par_list = get(handles.popupmenu1, 'String');
      [pathstr, name] = fileparts(dir_info.rxns_dir);
      
parameter_sets = get(handles.edit_paramsets,'String');
dir_info.parameter_sets = parameter_sets;

    fprintf(fid,'models_dir = pwd; \n');
    fprintf(fid,'specific_model_dir = ''%s''; \n',name);
    fprintf(fid,'parameters_dir = ''%s''; \n',par_list{par_index});
    fprintf(fid,'output_directory = []; \n');
        if ~isempty(dir_info.parameter_sets)
        fprintf(fid,'parameter_sets = ''%s''; \n',dir_info.parameter_sets);
    else
        fprintf(fid,'parameter_sets = []; \n');
    end

      fclose(fid);
      movefile(temp_file,def_file);

 function varargout = init_gui_data(mod_dir, handles)
%set data for MODEL (edit1) and PARAMETER (popupmenu1)lists

global dir_info

[path_str, str] = fileparts(mod_dir);
set(handles.edit1,'String', str);

% Set popupmenu1

dir_struct = dir(mod_dir);
ind = 1;
n_files=size(dir_struct,1);
for i = 3:n_files 
     if dir_struct(i).isdir
        p_dir = fullfile(mod_dir,dir_struct(i).name);
        dir_struct_p = dir(p_dir);
        np_files = size(dir_struct_p,1);
        good_param_dir = 0;
        for j = 3:np_files

                if strcmp(dir_struct_p(j).name,'general_constants.m')
                    good_param_dir = good_param_dir + 1;
                end
                if strcmp(dir_struct_p(j).name,'storing_and_plotting.m')
                    good_param_dir = good_param_dir + 1;
                end

        end
        if good_param_dir >= 2  
            dir_names{ind} = dir_struct(i).name;
            ind = ind + 1;
        end
    end
end
    
 if ind == 1
     set(handles.popupmenu1,'String','No parameters','Value',1);
 else    
     set(handles.popupmenu1,'String',dir_names,...
	'Value',1);     
    param_dir = fullfile(mod_dir,dir_names{1});   
    dir_info.param_dir = param_dir;
    dir_info.output_dir = fullfile(param_dir,'output');
    file_list = dir(param_dir);
         
    handles.isSBML = 0;
    handles.SBML_Model = [];
    handles.sbml_file = [];
    
    for i = 1:size(file_list,1)
        file_name = file_list(i).name;
        if ~isempty(strfind(file_name,'.xml'))
            full_name = fullfile(param_dir,file_name);
            test = TranslateSBML(full_name);
            if isSBML_Model(test)
                handles.isSBML = 1;
                handles.SBML_Model = test;
                handles.sbml_file = file_name;
                break;
            end
        end
    end
    
           set(handles.edit_paramsets,'String', '');
 end
 
varargout{1} = handles;

% --- Executes during object creation, after setting all properties.
function popupmenu2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


