#include "runsim.h"

/* function to prevent duplicate values in the dependency matrix.    */
int is_unique(int num_rxn, int depend[], int rxn_id)
{
       int i, unique;
       unique = 1; /*  unique, ie rxn doesn't depends on rxn_id   */
       for (i = 0; i < num_rxn; i++) 
        {
               if (depend[i] == rxn_id)
              { 
                       unique = 0;   /* NOT unique, already depends */
                       break;
               }
       }
       return unique;
}

int compare(const int *num1, const int *num2)
{
     return (*num1 - *num2);
}

void calc_dependency(struct array_sizes *arsz_ptr, struct rxn* arxn)
{
       int i, j, k, l;
       int num_rxns = arsz_ptr->num_rxns;
       int num_depend = 0;
       int *depend; 

       depend = (int *)calloc(num_rxns,sizeof(int));
           
       /* determine which reactions share the same substrates.    */
       for (i = 0; i < num_rxns; i++) 
        {
       /* fill the temporary  array with some dummy values    */
             for (j = 0; j < num_rxns; j++) 
               depend[j] = -1;
               num_depend = 0;

               for (j = 0; j < num_rxns; j++) 
                 {
                       for (k = 0; k < arsz_ptr->num_subs[i]; k++) 
                         {
                               for (l = 0; l < arsz_ptr->num_subs[j]; l++) 
                                {
                                       if (arxn[i].substrates[k] == arxn[j].substrates[l]) 
                                         {
                                               if (is_unique(num_rxns, depend, j)) 
                                                {
                                                       depend[num_depend] = j;
                                                       num_depend++;
                                                 }
                                           }
                                   }
                            }
                    }


       /* determine which reactions have substrates that are products of other reactions.  */

               for (j = 0; j < num_rxns; j++) 
               {
                       for (k = 0; k < arsz_ptr->num_prods[i]; k++) 
                        {
                               for (l = 0; l < arsz_ptr->num_subs[j]; l++ ) 
                                {
                                       if (arxn[i].products[k] == arxn[j].substrates[l]) 
                                         {
                                               if (is_unique(num_rxns, depend, j)) 
                                                {
                                                       depend[num_depend] = j;
                                                       num_depend++;
                                                 }
                                          }
                                 }
                          }
                 }
/*   Save results into rxn structure     */
            arsz_ptr->num_dependent[i] =  num_depend;
            arxn[i].rxn_depend = (int *)calloc(num_depend, sizeof(int));
                for (j = 0; j < num_depend; j++) 
                             arxn[i].rxn_depend[j] = depend[j];
                
                qsort(arxn[i].rxn_depend, num_depend, sizeof(int), (void *)compare);   
      } 

}

