#include "runsim.h"

double rxn_prob_undef(
  struct rxn *arxn,
  struct cmpd_data *cmpds  )
{
/*  Propensity functions for reactions with defined Kinetic Law
**   Parameters and rates are assigned in prepare_undef_reactions
**   Need to assign the number of compounds   
*/
     double ai=0;
   int P1;
   int RNAp;
   int RNAp_P1;
   int RNAp_RBS1;
   int RBS1;
   int Rib;
   int Rib_RBS1;
   int Rib_Prot1;
   int Prot1;
   int P2;
   int RNAp_P2;
   int RNAp_RBS2;
   int RBS2;
   int Rib_RBS2;
   int Rib_Prot2;
   int Prot2;
   int Prot2_2;
   int Prot2_4;
   int AA_E;
   int Prot1_E;
   int AA_C;
   int Prot1_E_C;
   int Prot1_GC;
   int GC;
   int Prot2_4_GC;
   int AA_G;
   int Prot2_4_GC_G;
   int Prot2_4_GSH;
   int GSH;
   int Prot1_GSH;
     switch(arxn->id)
	{
       case 0:
       P1 = cmpds[1].value;
       RNAp = cmpds[0].value;
       ai = arxn->rates[1].value *RNAp*P1/5e-016;
       
	break;
       case 1:
       RNAp_P1 = cmpds[2].value;
       ai = arxn->rates[0].value *RNAp_P1;
       
	break;
       case 2:
       RNAp_P1 = cmpds[2].value;
       ai = arxn->rates[0].value *RNAp_P1;
       
	break;
       case 3:
       RNAp_RBS1 = cmpds[3].value;
       ai = arxn->rates[0].value *RNAp_RBS1;
       
	break;
       case 4:
       RBS1 = cmpds[4].value;
       Rib = cmpds[5].value;
       ai = arxn->rates[0].value *Rib*RBS1/5e-016;
       
	break;
       case 5:
       Rib_RBS1 = cmpds[6].value;
       ai = arxn->rates[0].value *Rib_RBS1;
       
	break;
       case 6:
       Rib_RBS1 = cmpds[6].value;
       ai = arxn->rates[0].value *Rib_RBS1;
       
	break;
       case 7:
       Rib_Prot1 = cmpds[7].value;
       ai = arxn->rates[0].value *Rib_Prot1;
       
	break;
       case 8:
       Prot1 = cmpds[8].value;
       ai = arxn->rates[0].value *Prot1;
       
	break;
       case 9:
       RBS1 = cmpds[4].value;
       ai = arxn->rates[0].value *RBS1;
       
	break;
       case 10:
       P2 = cmpds[11].value;
       RNAp = cmpds[0].value;
       ai = arxn->rates[0].value *RNAp*P2/5e-016;
       
	break;
       case 11:
       RNAp_P2 = cmpds[12].value;
       ai = arxn->rates[0].value *RNAp_P2;
       
	break;
       case 12:
       RNAp_P2 = cmpds[12].value;
       ai = arxn->rates[0].value *RNAp_P2;
       
	break;
       case 13:
       RNAp_RBS2 = cmpds[13].value;
       ai = arxn->rates[0].value *RNAp_RBS2;
       
	break;
       case 14:
       RBS2 = cmpds[14].value;
       Rib = cmpds[5].value;
       ai = arxn->rates[0].value *Rib*RBS2/5e-016;
       
	break;
       case 15:
       Rib_RBS2 = cmpds[15].value;
       ai = arxn->rates[0].value *Rib_RBS2;
       
	break;
       case 16:
       Rib_RBS2 = cmpds[15].value;
       ai = arxn->rates[0].value *Rib_RBS2;
       
	break;
       case 17:
       Rib_Prot2 = cmpds[16].value;
       ai = arxn->rates[0].value *Rib_Prot2;
       
	break;
       case 18:
       Prot2 = cmpds[17].value;
       ai = arxn->rates[0].value *Prot2;
       
	break;
       case 19:
       RBS2 = cmpds[14].value;
       ai = arxn->rates[0].value *RBS2;
       
	break;
       case 20:
       Prot2 = cmpds[17].value;
       ai = arxn->rates[0].value *Prot2*(Prot2-1)/2.0/5e-016;
       
	break;
       case 21:
       Prot2_2 = cmpds[20].value;
       ai = arxn->rates[0].value *Prot2_2;
       
	break;
       case 22:
       Prot2_2 = cmpds[20].value;
       ai = arxn->rates[0].value *Prot2_2*(Prot2_2-1)/2.0/5e-016;
       
	break;
       case 23:
       Prot2_4 = cmpds[21].value;
       ai = arxn->rates[0].value *Prot2_4;
       
	break;
       case 24:
       AA_E = cmpds[22].value;
       Prot1 = cmpds[8].value;
       ai = arxn->rates[0].value *Prot1*AA_E/5e-016;
       
	break;
       case 25:
       Prot1_E = cmpds[23].value;
       ai = arxn->rates[0].value *Prot1_E;
       
	break;
       case 26:
       AA_C = cmpds[24].value;
       Prot1_E = cmpds[23].value;
       ai = arxn->rates[0].value *Prot1_E*AA_C/5e-016;
       
	break;
       case 27:
       Prot1_E_C = cmpds[25].value;
       ai = arxn->rates[0].value *Prot1_E_C;
       
	break;
       case 28:
       Prot1_E_C = cmpds[25].value;
       ai = arxn->rates[0].value *Prot1_E_C;
       
	break;
       case 29:
       Prot1_GC = cmpds[26].value;
       ai = arxn->rates[0].value *Prot1_GC;
       
	break;
       case 30:
       GC = cmpds[27].value;
       Prot2_4 = cmpds[21].value;
       ai = arxn->rates[0].value *Prot2_4*GC/5e-016;
       
	break;
       case 31:
       Prot2_4_GC = cmpds[28].value;
       ai = arxn->rates[0].value *Prot2_4_GC;
       
	break;
       case 32:
       AA_G = cmpds[29].value;
       Prot2_4_GC = cmpds[28].value;
       ai = arxn->rates[0].value *Prot2_4_GC*AA_G/5e-016;
       
	break;
       case 33:
       Prot2_4_GC_G = cmpds[30].value;
       ai = arxn->rates[0].value *Prot2_4_GC_G;
       
	break;
       case 34:
       Prot2_4_GC_G = cmpds[30].value;
       ai = arxn->rates[0].value *Prot2_4_GC_G;
       
	break;
       case 35:
       Prot2_4_GSH = cmpds[31].value;
       ai = arxn->rates[0].value *Prot2_4_GSH;
       
	break;
       case 36:
       GSH = cmpds[32].value;
       Prot1 = cmpds[8].value;
       ai = arxn->rates[0].value *Prot1*GSH/5e-016;
       
	break;
       case 37:
       Prot1_GSH = cmpds[33].value;
       ai = arxn->rates[0].value *Prot1_GSH;
       
	break;
       }    /*   End switch     */
   return ai; 
  }
