#include "runsim.h"

void update_rxn_prob_all( struct rxn *rxn_ptr, 
                          struct cmpd_data *cmpds, 
                          struct run_constants *r_c, 
                          struct array_sizes *arsz_ptr,
                          double tnext)
{
	
	int i;
	double random_num;
	

	for (i = 0; i < arsz_ptr -> num_rxns; i++) 
      {
          rxn_ptr[i].ai = calc_rxn_prob_erg(&rxn_ptr[i], cmpds, r_c, arsz_ptr, i);
 
		if (r_c->stoch_algor != 2) 
            {
		    if (rxn_ptr[i].ai < 1.0e-30) 
				rxn_ptr[i].rxn_time = DBL_MAX;
		
		    else 
                {
			random_num = ranf();    
				rxn_ptr[i].rxn_time = tnext + (1 / rxn_ptr[i].ai) * log(1/random_num);
		     }
		 }	
	  }
}
