#include "runsim.h"

void update_rxn_prob_erg(double *ai_sum_ptr, struct rxn *rxn_ptr, int rxnnum, struct cmpd_data *cmpds, double tnext, struct run_constants *r_c, struct array_sizes *arsz_ptr)
{
	
	int i, num_to_update, rxn_to_update;
	double random_num;
	
	num_to_update = arsz_ptr -> num_dependent[rxnnum];

	for (i = 0; i < num_to_update; i++) 
    {
		rxn_to_update = rxn_ptr[rxnnum].rxn_depend[i];
        rxn_ptr[rxn_to_update].ai = calc_rxn_prob_erg(&rxn_ptr[rxn_to_update], cmpds, r_c, arsz_ptr, rxn_to_update);

		if (r_c->stoch_algor != 2) 
        {
			rxn_ptr[rxn_to_update].ai = calc_rxn_prob_erg(&rxn_ptr[rxn_to_update], cmpds, r_c, arsz_ptr, rxn_to_update);
			if (rxn_ptr[rxn_to_update].ai < 1.0e-30) 
				rxn_ptr[rxn_to_update].rxn_time = DBL_MAX;
		
			else 
            {
			random_num = ranf();    
/*                random_num = drand(); */
				rxn_ptr[rxn_to_update].rxn_time = tnext + (1 / rxn_ptr[rxn_to_update].ai) * log(1/random_num);
			}
			
		 }
		
	  }
	
	if (r_c->stoch_algor == 2) {
		*ai_sum_ptr = 0;
		for (i = 0; i < arsz_ptr -> num_rxns; i++) {
			*ai_sum_ptr = *ai_sum_ptr + rxn_ptr[i].ai;
		}
	}

}
