function varargout = bns_plot(varargin)

% used to plot snapshot files for 1 or more runs
% all must use the same plot_info (same number of plots, same compounds in
% each plot) and the same run_info (same time points)

% If 2 arguments, 1st must be full path to output directory and 2nd must be
% the setsname (currently called output_filename)

% If 0 arguments, it will get output directory and output_filename from default
% directories.

if nargin == 2
    output_dir = varargin{1};
    data_partname = [varargin{2} '_data'];
    rundata_file = [varargin{2} '_rundata.mat'];
elseif nargin == 0
    default_directories
    
    if isempty(output_directory)
        output_directory = 'output';
        output_dir = fullfile(models_dir,specific_model_dir,parameters_dir,output_directory);
    else
        output_dir = output_directory;
    end
    data_partname = [output_filename '_data'];
    rundata_file = [output_filename '_rundata.mat'];
else
    disp('Incorrect number of arguments.  Zero arguments means to use the output file specified in default_directories.m.')    
    disp('If one argument, it should be the full pathname of the output file.')    
    return
end


datafile_list = dir(fullfile(output_dir, [data_partname '*']));
num_datafiles = size(datafile_list,1);


% Load plot_info
if exist(fullfile(output_dir,rundata_file),'file')
    load(fullfile(output_dir,rundata_file), 'plot_info', 'run_info' )
else
    error([rundata_file ' does not exist'])
end

init_plots

for i = 1:num_datafiles
    if exist(fullfile(output_dir, datafile_list(i).name),'file')
        [data_time, data_cmpds, agr_event_log] = read_snapshot(fullfile(output_dir, datafile_list(i).name)); 
    else
        error([fullfile(output_dir, datafile_list(i).name) ' does not exist'])
    end
 
       if ~isempty(data_cmpds)
    
          if i == 1
             first_multiplot = 1;
          else
            first_multiplot = 0;
          end
         make_plots(data_time, data_cmpds, 1, first_multiplot, plot_info.organize)
       end

end

if ~isempty(data_cmpds)
    for i = 1:plot_info.organize.actual_num_plots
        figure(i)
    end
end


