function varargout = bns_plot_pe(varargin)

% used to plot eventlog files for 1 or more runs
% all must use the same plot_info (same number of plots, same compounds in
% each plot) and the same run_info (same time points)

% If 2 arguments, 1st must be full path to output directory and 2nd must be
% the setsname (currently called output_filename)

% If 0 arguments, it will get output directory and output_filename from default
% directories.


if nargin == 2
    output_dir = varargin{1};
    data_partname = [varargin{2} '_data'];
    parsed_partname = [varargin{2} '_parsed'];
elseif nargin == 0
    default_directories
    
    if isempty(output_directory)
        output_directory = 'output';
        output_dir = fullfile(models_dir,specific_model_dir,parameters_dir,output_directory);
    else
        output_dir = output_directory;
    end
    data_partname = [output_filename '_data'];
    parsed_partname = [output_filename '_parsed'];
%	output_filename = fullfile(output_dir,output_filename);
else
    disp('Incorrect number of arguments.  Zero arguments means to use the output file specified in default_directories.m.')    
    disp('If two arguments, they should (1) be the full pathname of the output file and (2) the output_filename.')    
    return
end

datafile_list = dir(fullfile(output_dir, [data_partname '*.mat']));
num_datafiles = size(datafile_list,1);

parsedfile_list = dir(fullfile(output_dir, [parsed_partname '*.mat']));
num_parsedfiles = size(parsedfile_list,1);

% since all runs are with same plot_info, use first one
if exist(fullfile(output_dir, datafile_list(1).name),'file')
    load(fullfile(output_dir, datafile_list(1).name), 'plot_info', 'run_info')
else
    error([fullfile(output_dir, datafile_list(1).name) ' does not exist'])
end


monitor_cmpds_gid = plot_info.monitor_cmpds_gid;
time_end = run_info.time_end;

% make the plots have steps.  i.e.  compound numbers change at a specific
% instant, not over time.

stp_data_time = [];
stp_data_cmpds = [];
for nrun = 1:num_parsedfiles
    load(fullfile(output_dir, parsedfile_list(nrun).name), 'data_time', 'data_cmpds')
    
    for k = 1:length(monitor_cmpds_gid)
        dt = data_time{k};
        dc = data_cmpds{k};
        num_events = length(dt);
        sdt = zeros(num_events*2,1);
        sdc = zeros(num_events*2,1);
        
        sdt(1) = dt(1);
        sdc(1) = dc(1);
        for i = 2:num_events
            sdt(i*2-2) = dt(i);
            sdc(i*2-2) = dc(i-1);
            
            sdt(i*2-1) = dt(i);
            sdc(i*2-1) = dc(i);
        end
        sdt(num_events*2) = time_end;
        sdc(num_events*2) = dc(num_events);
        
        stp_data_time{k,nrun} = sdt;
        stp_data_cmpds{k,nrun} = sdc;
        
    end
end

[matlabversion,this_matlab_date] = version;
this_matlab_date = datenum(this_matlab_date);
matlab_700_date = datenum('July 1, 2003');
if this_matlab_date > matlab_700_date
    this_matlab_version = 7;
else
    this_matlab_version = 6;
end



linecolr = 'bgrcmyk';
plot_cols = plot_info.organize.plot_cols;
for i = 1:plot_info.organize.actual_num_plots
    figure(i);
    clf
    cla
    hold on
    for nrun = 1:num_parsedfiles
        for j = 1:length(plot_cols{i})
            plot(stp_data_time{plot_cols{i}(j),nrun}',stp_data_cmpds{plot_cols{i}(j),nrun},linecolr(mod(j-1,7)+1));
        end
    end
    hold off
    hleg = legend(plot_info.organize.plot_legends{i});
    if this_matlab_version == 7;
        set(hleg, 'Interpreter','none');
    end
end
drawnow    
