function rxgp = build_comps(subsname, rxgp, global_comp_names)
% create vector with global compound id for each compound in this reaction group

new_comp = 1;

num_old_comps = length(rxgp.comps);

for i = 1:num_old_comps
    if strcmp(subsname,rxgp.comps{i})
        new_comp = 0;
        break;
    end
end
    
if new_comp == 1
    comp_found = 0;
    rxgp.comps{num_old_comps+1} = subsname;
    for i = 1:length(global_comp_names);
        if strcmp(subsname, global_comp_names{i})
            rxgp.global_comp_gid = [rxgp.global_comp_gid i];
            comp_found = 1;
            break;
        end
    end
    if comp_found == 0
        error(['Substrate ' subsname ' does not have an entry in any file in the initial_compound_numbers subfolder in the parameters subfolder.'])
    end
        
end
