function varargout = choose_single_analysis(varargin)
% CHOOSE_SINGLE_ANALYSIS M-file for choose_single_analysis.fig
%      CHOOSE_SINGLE_ANALYSIS, by itself, creates a new CHOOSE_SINGLE_ANALYSIS or raises the existing
%      singleton*.
%
%      H = CHOOSE_SINGLE_ANALYSIS returns the handle to a new CHOOSE_SINGLE_ANALYSIS or the handle to
%      the existing singleton*.
%
%      CHOOSE_SINGLE_ANALYSIS('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in CHOOSE_SINGLE_ANALYSIS.M with the given input arguments.
%
%      CHOOSE_SINGLE_ANALYSIS('Property','Value',...) creates a new CHOOSE_SINGLE_ANALYSIS or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before choose_single_analysis_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to choose_single_analysis_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help choose_single_analysis

% Last Modified by GUIDE v2.5 16-Aug-2006 10:16:08

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @choose_single_analysis_OpeningFcn, ...
                   'gui_OutputFcn',  @choose_single_analysis_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before choose_single_analysis is made visible.
function choose_single_analysis_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to choose_single_analysis (see VARARGIN)

% Choose default command line output for choose_single_analysis
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

init_gui(hObject, handles, nargin, varargin)

% UIWAIT makes choose_single_analysis wait for user response (see UIRESUME)
% uiwait(handles.figure1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function init_gui(fig_handle, handles, nargin, varargin)

if nargin == 4
   set(handles.datafiletext, 'String', varargin{1}{1}.data_file)
   handles.data_dir = varargin{1}{1}.data_dir;
   handles.analysis_dir = varargin{1}{1}.analysis_dir;
   if isfield(varargin{1}{1},'pset_choice')
       handles.pset_choice = varargin{1}{1}.pset_choice;
   end
   if isfield(varargin{1}{1},'analysis_choice')
       handles.analysis_choice = varargin{1}{1}.analysis_choice;
       handles.analysis_init = 1;
   end
   guidata(fig_handle, handles)
else
    error('Incorrect number of arguments to choose_single_analysis.m')
end

file_string = get(handles.datafiletext, 'String');

pf = findstr(file_string,'_parsed_1');
df = findstr(file_string,'_data_1');
elf = findstr(file_string,'_eventlog_1');

if ~isempty(pf)
    name_core = file_string(1:pf(1)-1);
    datafile_name = [name_core '_rundata.mat'];
elseif ~isempty(elf)
    name_core = file_string(1:elf(1)-1);
    datafile_name = [name_core '_rundata.mat'];     
elseif ~isempty(df)
    name_core = file_string(1:df(1)-1);
    datafile_name = [name_core '_rundata.mat'];
end

datafile_wpath = fullfile(handles.data_dir, datafile_name);
if exist(datafile_wpath,'file')
    load(datafile_wpath, 'run_info')
    handles.run_info = run_info;
    guidata(fig_handle, handles)
else
    error([datafile_wpath ' does not exist.  If the data file choice was a parsed file, the corresponding _data_ file must also exist.'])
end

pset_list = [];
for i = 1:length(run_info.param_sets)
    pset_list{i} = num2str(i);
end
pset_list = pset_list';

if  ~isempty(pset_list)
    if isfield(handles, 'pset_choice')
        set(handles.param_popup, 'Value', handles.pset_choice);
        set(handles.param_popup, 'String', pset_list);
    else
        set(handles.param_popup, 'Value', 1);
        set(handles.param_popup, 'String', pset_list);
    end
else
    set(handles.param_popup, 'Value', 1);
    set(handles.param_popup, 'String', {'No Parameter Sets'});
end

evaluate_pset_choice(fig_handle, handles)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function evaluate_pset_choice(fig_handle, handles)
param_string_list = get(handles.param_popup, 'String');
param_string = param_string_list{get(handles.param_popup, 'Value')};

if strcmp(param_string, 'No Parameter Sets')
    set(handles.numrunstext,'String',num2str(handles.run_info.num_runs));
    set(handles.runtypetext,'String','N/A');
    set(handles.groupnametext,'String','N/A');

    set(handles.cmpd_popup, 'String', {'No modified compounds'});
    set(handles.cmpd_popup, 'Value', 1);
    set(handles.cmpdvaltext,'String','');

    set(handles.rate_popup, 'String', {'No modified rates'});
    set(handles.rate_popup, 'Value', 1);
    set(handles.ratevaltext,'String','');
    
    populate_analysis_choice(fig_handle,handles,[])
    
%    guidata(fig_handle,handles)
    return
end

pset_num = str2num(param_string);
pset = handles.run_info.param_sets(pset_num);

set(handles.numrunstext,'String',num2str(pset.numruns));
if isfield(pset,'type') && ~isempty(pset.type)
    set(handles.runtypetext,'String',pset.type);
else
    set(handles.runtypetext,'String','');
end
if isfield(pset,'set_group') && ~isempty(pset.set_group)
    set(handles.groupnametext,'String',pset.set_group);
else
    set(handles.groupnametext,'String','');
end
    

if ~isempty(pset.newinitcmpds)
    cmpd_list = struct2cell(pset.newinitcmpds);
    cmpdname_list = cmpd_list(1,:)';
    handles.cmpdval_list = cmpd_list(2,:)';
    set(handles.cmpd_popup, 'Value', 1);
    set(handles.cmpd_popup, 'String', cmpdname_list);
    set(handles.cmpdvaltext,'String',num2str(handles.cmpdval_list{1}));
else
    set(handles.cmpd_popup, 'Value', 1);
    set(handles.cmpd_popup, 'String', {'No modified compounds'});
    set(handles.cmpdvaltext,'String','');
end
    
if ~isempty(pset.newrateparms)
    rate_list = struct2cell(pset.newrateparms);
    ratename_list = rate_list(1,:)';
    handles.rateval_list = rate_list(2,:)';
    set(handles.rate_popup, 'Value', 1);
    set(handles.rate_popup, 'String', ratename_list);
    set(handles.ratevaltext,'String',num2str(handles.rateval_list{1}));
else
    set(handles.rate_popup, 'Value', 1);
    set(handles.rate_popup, 'String', {'No modified rates'});
    set(handles.ratevaltext,'String','');
end

guidata(fig_handle,handles);

populate_analysis_choice(fig_handle,handles,pset)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function populate_analysis_choice(fig_handle, handles, pset)

file_string = get(handles.datafiletext, 'String');

elf = findstr(file_string,'_eventlog_1');
pf = findstr(file_string,'_parsed_1');
df = findstr(file_string,'_data_1');

    analysis_list = {'average'};
    if isfield(pset,'type') && ~isempty(pset.type)
        if strcmp(lower(pset.type),'sensitivity')
            l_length = length(analysis_list);
            analysis_list{l_length + 1} = 'sensitivity';
        end
    end
            l_length = length(analysis_list);
            analysis_list{l_length + 1} = 'reaction frequency';


if isfield(handles,'analysis_choice')
    if handles.analysis_init == 1
        set(handles.analysis_popup, 'Value', handles.analysis_choice);
        set(handles.analysis_popup, 'String', analysis_list);
        handles.analysis_init = 0;
        guidata(fig_handle,handles);
    else
        set(handles.analysis_popup, 'Value', 1);
        set(handles.analysis_popup, 'String', analysis_list);
    end
else
    set(handles.analysis_popup, 'Value', 1);
    set(handles.analysis_popup, 'String', analysis_list);
end


% --- Outputs from this function are returned to the command line.
function varargout = choose_single_analysis_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on selection change in param_popup.
function param_popup_Callback(hObject, eventdata, handles)
% hObject    handle to param_popup (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns param_popup contents as cell array
%        contents{get(hObject,'Value')} returns selected item from param_popup

evaluate_pset_choice(handles.figure1, handles)

% --- Executes during object creation, after setting all properties.
function param_popup_CreateFcn(hObject, eventdata, handles)
% hObject    handle to param_popup (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in analysis_popup.
function analysis_popup_Callback(hObject, eventdata, handles)
% hObject    handle to analysis_popup (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns analysis_popup contents as cell array
%        contents{get(hObject,'Value')} returns selected item from analysis_popup


% --- Executes during object creation, after setting all properties.
function analysis_popup_CreateFcn(hObject, eventdata, handles)
% hObject    handle to analysis_popup (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in nextbutton.
function nextbutton_Callback(hObject, eventdata, handles)
% hObject    handle to nextbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


twa.data_file = get(handles.datafiletext, 'String');
twa.data_dir = handles.data_dir;
twa.analysis_dir = handles.analysis_dir;

param_string_list = get(handles.param_popup, 'String');
twa.pset_choice = get(handles.param_popup, 'Value');
twa.param_string = param_string_list{twa.pset_choice};

analysis_string_list = get(handles.analysis_popup, 'String');
twa.analysis_choice = get(handles.analysis_popup, 'Value');
analysis_string = analysis_string_list{twa.analysis_choice};


%close(choose_single_analysis)
close(handles.figure1)

if strcmp(analysis_string,'average')
    twa_analysis(twa)
elseif strcmp(analysis_string,'sensitivity')
    sens_analysis(twa)
elseif strcmp(analysis_string,'reaction frequency')
    plot_reaction_frequencies(twa)
end

% --- Executes on button press in backbutton.
function backbutton_Callback(hObject, eventdata, handles)
% hObject    handle to backbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

aod.data_file = get(handles.datafiletext, 'String');
aod.data_dir = handles.data_dir;
aod.analysis_dir = handles.analysis_dir;

close(handles.figure1)
analyze_olddata(aod)

% --- Executes on button press in exitbutton.
function exitbutton_Callback(hObject, eventdata, handles)
% hObject    handle to exitbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
close(handles.figure1)

% --- Executes on selection change in cmpd_popup.
function cmpd_popup_Callback(hObject, eventdata, handles)
% hObject    handle to cmpd_popup (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns cmpd_popup contents as cell array
%        contents{get(hObject,'Value')} returns selected item from cmpd_popup

if ~strcmp(get(hObject,'String'),'No modified compounds')
    set(handles.cmpdvaltext,'String',num2str(handles.cmpdval_list{get(hObject,'Value')}));
else
    set(handles.cmpdvaltext,'String','');
end
    


% --- Executes during object creation, after setting all properties.
function cmpd_popup_CreateFcn(hObject, eventdata, handles)
% hObject    handle to cmpd_popup (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in rate_popup.
function rate_popup_Callback(hObject, eventdata, handles)
% hObject    handle to rate_popup (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns rate_popup contents as cell array
%        contents{get(hObject,'Value')} returns selected item from rate_popup

if ~strcmp(get(hObject,'String'),'No modified rates')
    set(handles.ratevaltext,'String',num2str(handles.rateval_list{get(hObject,'Value')}));
else
    set(handles.ratevaltext,'String','');
end

% --- Executes during object creation, after setting all properties.
function rate_popup_CreateFcn(hObject, eventdata, handles)
% hObject    handle to rate_popup (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


