 output_dir = dir_info.output_dir;

if isempty(output_filename)
    output_filename = 'outfile';
end

% Delete old saved data with current output_filename. Otherwise there is confusion about which files
% were saved from which runs.  Use a new output_filename if you don't want
% to lose data.

dir_info.output_filename = output_filename;
output_file = fullfile(dir_info.output_dir, output_filename);
dir_info.output_file = output_file;

run_info.scaling_factor = scaling_factor;
run_info.volume0 = volume0; 
run_info.volume = volume; 
run_info.randseed = randseed;

run_info.monitor_interval = monitor_interval; 

run_info.time_start = time_start; 
run_info.time_end = time_end; 
run_info.num_runs = num_runs; 

run_info.stoch_algor = stoch_algor; 
run_info.tau_error = tau_error;

if use_paramset
    run_info.param_sets = pset;
else
    run_info.param_sets = [];
end


plot_info.monitor_cmpds = monitor_cmpds;
plot_info.plot_cmpds = plot_cmpds;

% c code needs to make an array of at least size 1, even if eventlogging
% turned off
if eventlog_flag == 0
    eventlog_arraysize = -abs(eventlog_maxelements);
elseif eventlog_maxelements <= 1
    eventlog_flag = 0;
    eventlog_arraysize = -10000;
    eventlog_maxelements = 10000; % since eventlog_maxelements is also used for snapshot data sizes
elseif eventlog_maxelements > 1 & eventlog_maxelements <= 10000
    eventlog_arraysize = eventlog_maxelements;
    eventlog_maxelements = 10000; % since eventlog_maxelements is also used for snapshot data sizes
else
    eventlog_arraysize = eventlog_maxelements;
end

plot_info.eventlog_flag = eventlog_flag; 
plot_info.eventlog_maxelements = eventlog_maxelements;
plot_info.eventlog_arraysize = eventlog_arraysize;

plot_info.snapshot_interval = snapshot_interval;
plot_info.plot_interval = plot_interval;

