  function [batch_file] = create_batch_analysis_LSF(BATCH)

% This function creates a batch script for the LSF queueing system.
% The function can be modified according to the specific requirements of the HPC system 

  temp_file = 'batch_tmp';
  batch_file = ['batch_', BATCH.prj_name];
  run_file_m = 'mpi_run.m';
  
  
  if exist(batch_file) ~=0
     delete(batch_file);
  end

   if exist(run_file_m) ~=0
     delete(run_file_m);
   end
  
  if exist(temp_file) ~=0
     delete(temp_file);
  end
  
  frun = fopen(run_file_m,'w');
  fprintf(frun,'usempi_analysis(%d)\n',BATCH.num_proc);
  fclose(frun); 
   

  fid = fopen(temp_file,'w');

  % Create a header of the batch script
  fprintf(fid,'#!/bin/csh \n');
  fprintf(fid,'#BSUB -q standard  \n');
  fprintf(fid,'#BSUB -n %d \n',BATCH.num_proc);
  fprintf(fid,'#BSUB -W %s \n',BATCH.wall_time);
  fprintf(fid,'#BSUB -J %s \n',BATCH.prj_name);
  fprintf(fid,'#BSUB -o %s \n',BATCH.stdout_file);
  fprintf(fid,'#BSUB -e %s \n',BATCH.stderr_file);
  fprintf(fid,'#BSUB -a %s \n',BATCH.a_type);
  %   Write the rest of the script
  fprintf(fid,'# \n# \n');
  fprintf(fid,'#   First step: Copy files into the working directory      # \n');
  fprintf(fid,'cp usempi_analysis.m  read_timesexecuted.m make_time_plots.m read_snapshot.m reaction_freq_analysis_mpi.m $WORK_DIR\n');
  fprintf(fid,'cp save_mat.m read_logdata.m mpi_run.m analysis_constants.m twui_ave.m twa_calc_mpi.m $WORK_DIR \n');
  fprintf(fid,'# \n');
  % Check for need of parsing
  
  analysis_constants
  elf = findstr(data_file,'_eventlog_1');
  
if ~isempty(elf)
      run_pe_file = 'mpi_pe.m';
  if exist(run_pe_file) ~=0
     delete(run_pe_file);
  end
  
  frun_pe = fopen(run_pe_file,'w');
  fprintf(frun_pe,'eval(MPI_Run(''bns_pe_mpi'',%d,{}))\n',BATCH.num_proc);
  fclose(frun_pe); 
fprintf(fid,'cp bns_pe_mpi.m mpi_pe.m $WORK_DIR\n');
end

  fprintf(fid,'#  Lets change to the working directory\n# \n');
  fprintf(fid,'cd $WORK_DIR\n# \n');
% Run parsing
  if ~isempty(elf)
  fprintf(fid,'matlab -nojvm -nosplash -nodisplay -nodesktop -r mpi_pe \n');
  fprintf(fid,'/bin/rm -rf MatMPI\n');
  end
  fprintf(fid,'#  Now lets run analysis\n# \n');
  fprintf(fid,'matlab -nojvm -nosplash -nodisplay -nodesktop -r mpi_run \n');
  
  fprintf(fid,'#   DONE \n# \n');
  fprintf(fid,'exit \n# \n');
  fprintf(fid,'# Batch script created by bns_GUI \n# \n# \n');
  fclose(fid);
% Save batch file
  movefile(temp_file, batch_file);

