  function [batch_file] = create_batch_script_LSF(dir_info, BATCH)

% This function creates a batch script for the LSF queueing system.
% The function can be modified according to the specific requirements of the HPC system 

  temp_file = 'batch_tmp';
  batch_file = ['batch_', BATCH.prj_name];
  if exist(temp_file) ~=0
     delete(temp_file);
  end
  fid = fopen(temp_file,'w');

  rundata_file = [dir_info.output_dir '/' dir_info.output_filename '_rundata.mat'];

  % Create a header of the batch script
  fprintf(fid,'#!/bin/csh \n');
  fprintf(fid,'#BSUB -q standard  \n');
  fprintf(fid,'#BSUB -n %d \n',BATCH.num_proc);
  fprintf(fid,'#BSUB -W %s \n',BATCH.wall_time);
  fprintf(fid,'#BSUB -J %s \n',BATCH.prj_name);
  fprintf(fid,'#BSUB -o %s \n',BATCH.stdout_file);
  fprintf(fid,'#BSUB -e %s \n',BATCH.stderr_file);
  fprintf(fid,'#BSUB -a %s \n',BATCH.a_type);
  %   Write the rest of the script
  fprintf(fid,'# \n# \n');
  fprintf(fid,'#   First step: run bns(0,2) to create bns_mpi.exe file   # \n');
  fprintf(fid,'matlab -nojvm -nosplash -nodisplay -nodesktop -r run_mpi \n');
  fprintf(fid,'# \n');
  fprintf(fid,'#  Copy bns_mpi, constants.txt ind rundata_file nto the working directory       \n# \n');
  fprintf(fid,'cp bns_mpi.exe constants.txt %s $WORK_DIR\n# \n',rundata_file);
  fprintf(fid,'#  Lets change to the working directory\n# \n');
  fprintf(fid,'cd $WORK_DIR\n# \n');
  fprintf(fid,'#  Run the job        \n# \n');
  fprintf(fid,'mpirun  -n %d bns_mpi.exe\n',BATCH.num_proc);
  fprintf(fid,'# \n');
  fprintf(fid,'#  Tar output results                          \n');
  fprintf(fid,'tar -cf ../%s.tar * \n# \n',BATCH.prj_name);
% Copy results into the $HOME directory 
  fprintf(fid,'cp ../%s.tar $HOME \n# \n',BATCH.prj_name);
  fprintf(fid,'#   DONE \n# \n');
  fprintf(fid,'exit \n# \n');
  fprintf(fid,'# Batch script created by bns_GUI \n# \n# \n');
  fclose(fid);
% Save batch file
  movefile(temp_file, batch_file);

