function dep_mat = create_dependency_matrix(rxn, dep_mat, min_depend)

%orig_dep_mat = dep_mat;
num_rxns = length(rxn);

for i = 1:num_rxns  %i is the current reaction, we are trying to determine which other 
                    %reactions are affected by the execution of this reaction
    num_to_change = length(dep_mat{i});
    for j = 1:num_rxns  %what other reactions j must be changed due to execution of i
%        if isempty(orig_dep_mat{j}) % if orig_dep_mat{j} not empty, then don't allow any reaction to trigger an update of j reaction.  
                                    % This prevents unnecessary updates of thousands of transcription steps when ATP somewhere else changes.
        if min_depend(j) == 0 % if orig_dep_mat{j} not empty, then don't allow any reaction to trigger an update of j reaction.  
                                    % This prevents unnecessary updates of thousands of transcription steps when ATP somewhere else changes.
            for k = 1:size(rxn{i}.substrates,1)
                for l = 1:size(rxn{j}.substrates,1)
                    if rxn{i}.substrates(k,1) == rxn{j}.substrates(l,1)
                        num_to_change = num_to_change + 1;
                        dep_mat{i}(num_to_change) = j;
                    end
                end
            end
            for k = 1:size(rxn{i}.products,1)
                for l = 1:size(rxn{j}.substrates,1)
                    if rxn{i}.products(k,1) == rxn{j}.substrates(l,1)
                        num_to_change = num_to_change + 1;
                        dep_mat{i}(num_to_change) = j;
                    end
                end
            end
        end
    end
    
    dep_mat{i} = unique(dep_mat{i});
    
end


