function d_dt = determ_deq(t,x,num_cmpds, rxn_all)

R = zeros(num_cmpds,1);

for i = 1:length(rxn_all)
    rxn = rxn_all{i};
    
    switch rxn.type
        
        case {'n-order'}

            subs = rxn.substrates;
            num_subs = size(subs,1);
            prods = rxn.products;
            num_prods = size(prods,1);
            rate = rxn.StoP.rate;
            for j = 1:num_subs
                rate = rate .* (x(subs(j,2)) .^ subs(j,3));
            end
            for j = 1:num_subs
                R(subs(j,2)) = R(subs(j,2)) - subs(j,1) .* rate;
            end
            for j = 1:num_prods
                R(prods(j,2)) = R(prods(j,2)) + prods(j,1) .* rate;
            end
            
    end
end


d_dt = R;

