% Reaction rate constants and rate laws

% Association of T7 polymerase (s2) with T7 promoter (s1)

r1.ltor.rate.k1 = 1e-18;
r1.ltor.rate.V = 5e-16;
r1.ltor.rate.formula = 'k1 * s1 * s2 / V';
r1.rxn_grp = 1;

% Dissociation of T7_RNAp-T7_P complex (s3)

r2.ltor.rate.k2 = 1e-1;
r2.ltor.rate.formula = 'k2 * s3';
r2.rxn_grp = 1;

% gshA_mRNA (s8) formation

r3.ltor.rate.k3 = 1e-1;  %5e-1;
r3.ltor.rate.km3_1 = 301;
r3.ltor.rate.km3_2 = 301;
r3.ltor.rate.km3_3 = 301;
r3.ltor.rate.km3_4 = 301;
r3.ltor.rate.formula = 'k3 * s3 * (s4 / (s4 + km3_1)) * (s5 / (s5 + km3_2)) * (s6 / (s6 + km3_3)) * (s7 / (s7 + km3_4))';
r3.rxn_grp = 1;

% Degradation of gahA_mRNA (s8) by the RAase (s42)

r4.ltor.rate.k4 = 1e-17; %1e-15; %1e-8; %1e-4; %1e-20;  %5e-20;  %5e-19
r4.ltor.rate.V = 5e-16;
r4.ltor.rate.km4 = 301;
r4.ltor.rate.formula = 'k4 * (s42 / V) * s8 / (s8 + km4)';
r4.rxn_grp = 1;

% Association of Ribs (s14) with ribosomal binding site on gshA_mRNA (s8)

r5.ltor.rate.k5 = 1e-18;
r5.ltor.rate.V = 5e-16;
r5.ltor.rate.formula = 'k5 * s8 * s14 / V';
r5.rxn_grp = 1;

% Dissociation of Ribs-gshA_mRNA complex (s15)

r6.ltor.rate.k6 = 1e-1;
r6.ltor.rate.formula = 'k6 * s15';
r6.rxn_grp = 1;

% GSHA protein (s37) formation

r7.ltor.rate.k7 = 5e-3;  %1e-2; % 2e-2; %5e-2;
r7.ltor.rate.km7_4 = 301;
r7.ltor.rate.km7_5 = 301;
r7.ltor.rate.km7_15 = 301;
r7.ltor.rate.km7_17 = 301;
r7.ltor.rate.km7_18 = 301;
r7.ltor.rate.km7_19 = 301;
r7.ltor.rate.km7_20 = 301;
r7.ltor.rate.km7_21 = 301;
r7.ltor.rate.km7_22 = 301;
r7.ltor.rate.km7_23 = 301;
r7.ltor.rate.km7_24 = 301;
r7.ltor.rate.km7_25 = 301;
r7.ltor.rate.km7_26 = 301;
r7.ltor.rate.km7_27 = 301;
r7.ltor.rate.km7_28 = 301;
r7.ltor.rate.km7_29 = 301;
r7.ltor.rate.km7_30 = 301;
r7.ltor.rate.km7_31 = 301;
r7.ltor.rate.km7_32 = 301;
r7.ltor.rate.km7_33 = 301;
r7.ltor.rate.km7_34 = 301;
r7.ltor.rate.km7_35 = 301;
r7.ltor.rate.km7_36 = 301;
r7.ltor.rate.formula = 'k7 * s16 * (s4 / (s4 + km7_4)) * (s5 / (s5 + km7_5)) * (s15 / (s15 + km7_15)) * (s17 / (s17 + km7_17)) * (s18 / (s18 + km7_18)) * (s19 / (s19 + km7_19)) * (s20 / (s20 + km7_20)) * (s21 / (s21 + km7_21)) * (s22 / (s22 + km7_22)) * (s23 / (s23 + km7_23)) * (s24 / (s24 + km7_24)) * (s25 / (s25 + km7_25)) * (s26 / (s26 + km7_26)) * (s27 / (s27 + km7_27)) * (s28 / (s28 + km7_28)) * (s29 / (s29 + km7_29)) * (s30 / (s30 + km7_30)) * (s31 / (s31 + km7_31)) * (s32 / (s32 + km7_32)) * (s33 / (s33 + km7_33)) * (s34 / (s34 + km7_34)) * (s35 / (s35 + km7_35)) * (s36 / (s36 + km7_36)) ';
r7.rxn_grp = 1;

% gamma-glutamyl-cysteine (s41) formation

r8.ltor.rate.k8 = 5e-1; %1e-1;
r8.ltor.rate.km8_4 = 301;
r8.ltor.rate.km8_29 = 301;
r8.ltor.rate.km8_33 = 301;
r8.ltor.rate.formula = 'k8 * s37 * (s4 / (s4 + km8_4)) * (s29 / (s29 + km8_29)) * (s33 / (s33 + km8_33)) ';
r8.rxn_grp = 1;

% Degradation of GSHA protein (s37) by generic protease (s43) - competitive
% inhibition by other protein substrates

r9.ltor.rate.k9 = 1e-14; %1e-11; %2e-7; %2e-23;  %1e-22;  %1e-30
r9.ltor.rate.V = 5e-16;
r9.ltor.rate.km9 = 301;
r9.ltor.rate.km10 = 301;
r9.ltor.rate.km11 = 301;
r9.ltor.rate.km12 = 301;
r9.ltor.rate.formula = 'k9 * (s43 / V) * s37 / (s37 + km9 * (1 + (s42 / km10) +(s2 / km11) + (s43 / km12)))';
r9.rxn_grp = 1;

% Degradation of RNase (s42) by generic protease (s43) - competitive
% inhibition by other protein substrates

r10.ltor.rate.k10 = 1e-14; %1e-11; 2e-7; %2e-23;  %1e-22; %1e-30
r10.ltor.rate.V = 5e-16;
r10.ltor.rate.km9 = 301;
r10.ltor.rate.km10 = 301;
r10.ltor.rate.km11 = 301;
r10.ltor.rate.km12 = 301;
r10.ltor.rate.formula = 'k10 * (s43 / V) * s42 / (s42 + km10 * (1 + (s37 / km9) +(s2 / km11) + (s43 / km12)))';
r10.rxn_grp = 1;

% Degradation of T7 polymerase (s2) by generic protease (s43) - competitive
% inhibition by other protein substrates

r11.ltor.rate.k11 = 2e-14; %1e-11; %2e-7; %2e-23;  %1e-22; %1e-30
r11.ltor.rate.V = 5e-16;
r11.ltor.rate.km9 = 301;
r11.ltor.rate.km10 = 301;
r11.ltor.rate.km11 = 301;
r11.ltor.rate.km12 = 301;
r11.ltor.rate.formula = 'k11 * (s43 / V) * s2 / (s2 + km11 * (1 + (s37 / km9) +(s42 / km10) + (s43 / km12)))';
r11.rxn_grp = 1;

% Self-degradation of generic protease (s43) - competitive inhibition by other protein substrates

r12.ltor.rate.k12 = 1e-14; %1e-11; 2e-7; %2e-23;  %1e-22; % 1e-30
r12.ltor.rate.V = 5e-16;
r12.ltor.rate.km9 = 301;
r12.ltor.rate.km10 = 301;
r12.ltor.rate.km11 = 301;
r12.ltor.rate.km12 = 301;
r12.ltor.rate.formula = 'k12 * (s43 / V) * s43 / (s43 + km12 * (1 + (s37 / km9) +(s42 / km11) + (s43 / km12)))';
r12.rxn_grp = 1;



