
plot_cmpds = plot_info.plot_cmpds;
monitor_cmpds = plot_info.monitor_cmpds;

if strcmp(plot_cmpds{1},'all')
    num_plots = length(monitor_cmpds)
    for i = 1:num_plots
        plot_cols{i} = i;
        plot_legends{i} = monitor_cmpds{i};
    end
    actual_num_plots = num_plots;
else
    num_plots = length(plot_cmpds);
    num_monitored = length(monitor_cmpds);
    plot_num = 1;
    for i = 1:num_plots
        plot_cols{plot_num} = [];
        legend_num = 0;
        num_cmpds_this_plot = length(plot_cmpds{i});
        for j = 1:num_cmpds_this_plot
            for k = 1:num_monitored
                if strcmp(plot_cmpds{i}{j},monitor_cmpds{k})
                    plot_cols{plot_num} = [plot_cols{plot_num} k];
                    legend_num = legend_num + 1;
                    temp_plot_legends{plot_num}{legend_num} = plot_cmpds{plot_num}{j};
                end
            end
        end
        if isempty(plot_cols{i})
            warning('a compound to be plotted did not have a corresponding entry in monitor_cmpds, so no data is available')
        else
            plot_num = plot_num + 1;
        end
    end
    
    actual_num_plots = plot_num - 1;
    for i = 1:actual_num_plots
        plot_legends{i} = char(temp_plot_legends{i});
    end
end

%get rid of excess figures from previous data in storing_and_plotting (can occur if
%storing and plotting has been changed)
cur_num_plots = length(get(0,'children'));
for i = actual_num_plots+1:cur_num_plots
    figure(i)
    close
end

plot_info.organize.plot_cols = plot_cols;
plot_info.organize.plot_legends = plot_legends;
plot_info.organize.actual_num_plots = actual_num_plots;

clear plot_cmpds
clear monitor_cmpds
clear plot_cols
clear plot_legends
clear actual_num_plots
