function [rxgp, ssdata,aglog] = init_rxn_grp(rxgp, time, cmpd_info, run_info, eventlog_arraysize, snapshot_interval, use_randseed)

num_rxns = length(rxgp.rxn);
randseed = run_info.randseed;
stoch_algor = run_info.stoch_algor;

% create molecular compound matrix, row is id of compound, 1st col is official #, 2nd col is putative changed #
cmpd_nums = create_cmpd_matrix(rxgp.global_comp_gid, cmpd_info);
rxgp.cmpd_nums = cmpd_nums.value;

rxgp.times_rxns_executed = zeros(num_rxns,1);    

%rxgp = update_rxn_grp(rxgp, time, volume, stoch_algor);

rand_seed = randseed;                 
if (use_randseed == 1) % if this is the first runsim for this cpu, seed the random number generator
[rxgp, tmp1, tmp2, ssdata, aglog] = coordinate_erg(rxgp, time, 0, run_info, 2, eventlog_arraysize, snapshot_interval);
else
[rxgp, tmp1, tmp2, ssdata, aglog] = coordinate_erg(rxgp, time, 0, run_info, 3, eventlog_arraysize, snapshot_interval);
end

%rand_seed = rand;   % change randseed from integer basis used for user input in general_constants.m to value between 0 and 1.
                    % Having known limits for randseed makes it easier to
                    % use in other functions.  rand_seed is then used to
                    % seed the c random number generator

rxgp = save_rxngrp_data(rxgp, rxgp.times_rxns_executed, stoch_algor);

