

disp('The default directories are specified in a text file called default_directories.txt') 
disp('in the directory where the bns program is located.')
disp(['The "current models directory" is  ' models_dir])

user_entry = input(['\nInput the "specific model sub-directory" name.  \nIt must be a sub-directory of the "current models directory". \n[' specific_model_dir ']:'], 's');
if ~isempty(user_entry)
    specific_model_dir = user_entry;
    rxns_dir = fullfile(models_dir,specific_model_dir);
end

user_entry = input(['\nInput "parameter sub-directory" name.  \nIt must be a sub-directory of the "specific model sub-directory". \n[' parameters_dir ']:'], 's');
if ~isempty(user_entry)
    parameters_dir = user_entry;
    param_dir = fullfile(models_dir,specific_model_dir,parameters_dir);
end

user_entry = input(['\nType the file name to store output data.  \nThe extension .mat will be appended to the filename typed here.' ...
                    '\nThe directory for this file, and the default filename, are specified' ...
                    '\nin the storing_and_plotting.m file. \n[' output_filename ']:'], 's');
if ~isempty(user_entry)
    output_filename = user_entry;
end

user_entry = input('\nInput any integer for the random number seed.  \nIf no integer is specified, the seed will be generated from the clock. \nTo use the random number seed from the previous run, enter the number 0:');
if ~isempty(user_entry)
    if user_entry == 0
        cd(param_dir);
        if exist('prev_randseed.mat','file')
            load prev_randseed
        else
            warning('No previous random number seed exists.  One will be randomly generated from the clock.')
            randseed = [];
        end
        cd(code_dir)
    else
        randseed = user_entry;
    end
end




