
rxns_dir = fullfile(models_dir,specific_model_dir);
param_dir = fullfile(models_dir,specific_model_dir,parameters_dir);

if exist(models_dir) == 0
    disp([models_dir '  was not found.  Fix models_dir entry in default_directories.m.']);
    return
end
if exist(rxns_dir) == 0
    disp([rxns_dir '  was not found.  Fix rxns_dir entry in default_directories.m.']);
    return
end
if exist(param_dir) == 0
    disp([param_dir '  was not found.  Fix param_dir entry in default_directories.m.']);
    return
end
if ~isempty(output_directory) & exist(output_directory) == 0
    disp([output_directory '  was not found.  Fix entry in default_directories.m.']);
    return
end


if nargin == 0
    use_GUI = 0;
    use_batch = 0;
elseif nargin >= 2 & nargin <= 6
	use_GUI = varargin{1};
	use_batch = varargin{2};
else
    disp('Incorrect number of arguments.  Can only have 0, 2, 3, 4, 5, or 6 arguments.')
    disp('Zero arguments will initiate a user dialogue.')
    disp('Two arguments will run the code with input from default_directories.m.')
    disp('Otherwise....')
    disp(' ')

    disp('Usage: bns([use_GUI, use_batch][, specific_model_dir][, parameters_dir][, output_filename][, randseed])');
    disp(['Current models directory is  ' models_dir]);
    disp(['Current specific model directory is  ' specific_model_dir]);
    disp(['Current parameters directory is  ' parameters_dir]);
    disp(['Current output directory is  ' output_directory]);
    disp(['Current output filename is  ' output_filename]);
    disp('An empty matrix should be used as a placeholder if one does not wish to change')
    disp('a particular argument from that in default_directories.m.');
    return 
end
    

if nargin == 0

    initial_user_dialogue
    
elseif nargin >= 3 & nargin <= 6

    specific_model_dir = varargin{3};
    rxns_dir = fullfile(models_dir,specific_model_dir);
    if ~isempty(specific_model_dir) & exist(rxns_dir) == 0
        disp([rxns_dir '  was not found.']);
        return
    end
    
    if nargin >= 4
        parameters_dir = varargin{4};
        param_dir = fullfile(rxns_dir,parameters_dir);
        if ~isempty(parameters_dir) & exist(param_dir) == 0
            disp([param_dir '  was not found']);
            return
        end

        if nargin >= 5
            if ~isempty(varargin{5})
                output_filename = varargin{5};
            end
            
            if nargin == 6
                randseed_cl = str2num(varargin{6});
            end
        end
    end
elseif nargin > 6
    return
end


if isempty(output_directory)
    output_directory = 'output';
    output_dir = fullfile(param_dir,output_directory);
else
    output_dir = output_directory;
end

dir_info.code_dir = code_dir;
dir_info.models_dir = models_dir;
dir_info.rxns_dir = rxns_dir;
dir_info.param_dir = param_dir;
dir_info.output_dir = output_dir;
dir_info.output_filename = output_filename;
%output_file = fullfile(output_dir, output_filename);
%dir_info.output_file = output_file;
dir_info.parameter_sets = parameter_sets;


