  % Batch script for ARL JVN machine
   function [batch_file] = jvn_batch(dif_info, BATCH)
 % Create a batch script for Linux JVN machine at ARL MSRC
  
  j_name = BATCH.prj_name;
  temp_file = 'batch_tmp';
  batch_file = ['batch_', j_name];
  if exist(temp_file) ~=0
     delete(temp_file);
  end
  rundata_file = [dir_info.output_dir '/' dir_info.output_filename '_rundata.mat'];
  
  fid = fopen(temp_file,'w');
  
  % Create header
  fprintf(fid,'#!/bin/csh \n');
  fprintf(fid,'#BSUB -q standard \n');
  fprintf(fid,'#BSUB -n %d \n',BATCH.num_proc);
  fprintf(fid,'#BSUB -W %s \n',BATCH.wall_time);
  fprintf(fid,'#BSUB -J %s \n',BATCH.prj_name);
  fprintf(fid,'#BSUB -o %s \n',BATCH.stdout_file);
  fprintf(fid,'#BSUB -e %s \n',BATCH.stderr_file);
  fprintf(fid,'#BSUB -a %s \n',BATCH.a_type);
  fprintf(fid,'#BSUB -P %s \n',BATCH.acct_nmbr);
  fprintf(fid,'#BSUB -m jvn \n\n');

  %   Write the rest of the script
  fprintf(fid,'setenv WORK_DIR /usr/var/tmp/${LOG_NAME}/${LSB_JOBID}\n');
  fprintf(fid,'mkdir -p ${WORK_DIR}\n');
  
  fprintf(fid,'# \n# \n'); 
  fprintf(fid,'#   First: run bns(0,2) to create bns_mpi.exe file   # \n');
  fprintf(fid,'matlab -nojvm -nosplash -nodisplay -nodesktop -r run_mpi \n');
  fprintf(fid,'# \n');
  fprintf(fid,'#  Now copy bns_mpi and constants.txt into work directory       \n# \n');
  fprintf(fid,'cp bns_mpi.exe constants.txt %s $WORK_DIR\n# \n',rundata_file);
  fprintf(fid,'#  Lets change to the working directory\n# \n');
  fprintf(fid,'cd $WORK_DIR\n# \n');
  fprintf(fid,'#  Run the job        \n# \n');
  fprintf(fid,'mpirun.lsf --gm-copy-env %d bns_mpi.exe\n',BATCH.num_proc);
  fprintf(fid,'# \n');
  fprintf(fid,'#  Tar output results                          \n');
  fprintf(fid,'tar -cf ../%s.tar * \n# \n',BATCH.prj_name);
  fprintf(fid,'# \n#   Copy out_file back to $HOME \n# \n');
  fprintf(fid,'cp ../%s.tar $ARCHIVE_HOME \n# \n',BATCH.prj_name);
  fprintf(fid,'#   DONE \n# \n');
  fprintf(fid,'exit \n# \n');
  fprintf(fid,'# Batch script created by bns_GUI \n# \n# \n');
  fclose(fid);
  
% Run the batch_script   
  movefile(temp_file, batch_file);
