function make_plots(data_time, data_cmpds, plot_multirun, first_multiplot, plot_organize);

[matlabversion,this_matlab_date] = version;
this_matlab_date = datenum(this_matlab_date);
matlab_700_date = datenum('July 1, 2003');
if this_matlab_date > matlab_700_date
    this_matlab_version = 7;
else
    this_matlab_version = 6;
end

plot_cols = plot_organize.plot_cols;

for i = 1:plot_organize.actual_num_plots
    
    if plot_multirun
        if first_multiplot
            if ishandle(i)
                set(0,'CurrentFigure',i)
                set(i,'visible','off')
                clf
                cla
            else
                figure('visible','off')
                clf
                cla
            end
        end
        set(0,'CurrentFigure',i)
        hold on
        plot(data_time,data_cmpds(:,plot_cols{i}));
        hold off
    else
        figure(i)
        clf
        cla
        plot(data_time,data_cmpds(:,plot_cols{i}));
    end
    hleg = legend(plot_organize.plot_legends{i});

    if this_matlab_version == 7;
        set(hleg, 'Interpreter','none');
    end
end
drawnow
    
