% function make_time_plots(pfd)

% used to analyze parsed eventlog files for parameter sets.


[matlabversion,this_matlab_date] = version;
this_matlab_date = datenum(this_matlab_date);
matlab_700_date = datenum('July 1, 2003');
if this_matlab_date > matlab_700_date
    this_matlab_version = 7;
else
    this_matlab_version = 6;
end

%analysis_constants

file_string = data_file;
param_set_num = str2num(param_string);
if isempty(plotcmpds) | ~iscell(plotcmpds)
    error(['No compounds to plot or incorrect format for the plotcmpds list']);
end

fig_handle = 1;

pf = findstr(file_string,'_parsed_1');
df = findstr(file_string,'_data');
if ~isempty(pf)
    name_core = file_string(1:pf(1)-1);
    datafile_core = [name_core '_data'];
    ssflag = 0;
    data_partname = [name_core '_parsed'];
    rundata_file = [name_core '_rundata.mat'];
elseif ~isempty(df)
    name_core = file_string(1:df(1)-1);
    datafile_core = [name_core '_data'];
    rundata_file = [name_core '_rundata.mat'];
    ssflag = 1;
    data_partname = [name_core '_data'];
end


datafilecore_wpath = fullfile(data_dir, datafile_core);

datafile_list = dir(datafilecore_wpath);

if exist(fullfile(data_dir, rundata_file),'file')
    load(fullfile(data_dir, rundata_file), 'plot_info', 'run_info', 'dir_info', 'cmpd_info', 'rxn_grp')
else
    error([fullfile(data_dir, rundata_file) ' does not exist'])
end
           
            save_file_name = fullfile(data_dir, name_core);
            save_file_name = [save_file_name '*fig*'];
            af_list = dir(save_file_name);
            af_list = struct2cell(af_list);
            af_list = af_list(1,:)';

            if ~isempty(af_list)
                delete(fullfile(data_dir, '*.fig'))
            end


pset = run_info.param_sets;

if ~isempty(pset)
    num_psets = length(pset);
    cur_runid = 1;
    for i = 1:num_psets
        pset(i).first_runid = cur_runid;
        cur_runid = cur_runid + pset(i).numruns;
    end
    this_pset = pset(param_set_num);
    num_runs = this_pset.numruns;
    first_psetrunid = this_pset.first_runid;
else
    num_runs = run_info.num_runs;
    first_psetrunid = 1;
end

adatafilename_thispset = [name_core '_data'];

% create list of compounds that are to be included in plots, each compound occurring only once in this list
if cmpdgrp
    cmpdlist = [];
    numfigs = length(plotcmpds);
    if isempty(plotcmpds{numfigs})
        numfigs = numfigs-1;
    end

    % start with first figure
    cmpd_num = 1;
    cmpdlist{cmpd_num} = plotcmpds{1}(1);
    fig_idx{1} = 1;

    numcmpds = length(plotcmpds{1});
    for j = 2:numcmpds
        cmpd_num = cmpd_num + 1;
        cmpdlist{cmpd_num} = plotcmpds{1}(j);
        fig_idx{1} = [fig_idx{1} j];
    end

    % do rest of figures
    for i = 2:numfigs
        numcmpds = length(plotcmpds{i});
        for j = 1:numcmpds
            cmpdlist_idx = find(strcmp(cmpdlist,plotcmpds{i}(j)));
            if isempty(cmpdlist_idx)    % a new compound for the list
                cmpd_num = cmpd_num + 1;
                cmpdlist{cmpd_num} = plotcmpds{i}(j);
                if length(fig_idx) < i
                    fig_idx{i} = cmpd_num;
                else
                    fig_idx{i} = [fig_idx{i} cmpd_num];
                end
            else    % this compound was already added to cmpdlist
                if length(fig_idx) < i
                    fig_idx{i} = cmpdlist_idx;
                else
                    fig_idx{i} = [fig_idx{i} cmpdlist_idx];
                end
            end
        end
    end
else
    cmpdlist = plotcmpds{1};
    numfigs = length(cmpdlist);
    for i = 1:numfigs
        fig_idx{i} = i;
        plotcmpds{i} = cmpdlist(i);
    end
end

        
analysis.cmpd = cmpdlist;
analysis.timeend = timeend;
analysis.timestart = timestart;

if length(analysis.cmpd) ~= 0
    first_runid = first_psetrunid + firstrun - 1;
    nruns = lastrun - firstrun + 1;
    [temp1, cmpdnames, time_vals, span_vals] = twui_ave(nruns, first_runid, data_dir, data_partname, analysis, plot_info, ssflag, timeend - timestart);

    stp_data_time = [];
    stp_data_cmpds = [];
    if ssflag
        for nrun = 1:nruns
            for k = 1:length(cmpdnames)
                stp_data_time{k,nrun} = time_vals{nrun,k};
                stp_data_cmpds{k,nrun} = span_vals{nrun,k};
            end
        end
    else
        % make the plots have steps
        for nrun = 1:nruns
            for k = 1:length(cmpdnames)
                dt = time_vals{nrun,k};
                dc = span_vals{nrun,k};
                num_events = length(dt);
                sdt = zeros(num_events*2,1);
                sdc = zeros(num_events*2,1);

                sdt(1) = dt(1);
                sdc(1) = dc(1);
                for i = 2:num_events
                    sdt(i*2-2) = dt(i);
                    sdc(i*2-2) = dc(i-1);

                    sdt(i*2-1) = dt(i);
                    sdc(i*2-1) = dc(i);
                end
                sdt(num_events*2) = analysis.timeend;
                sdc(num_events*2) = dc(num_events);

                stp_data_time{k,nrun} = sdt;
                stp_data_cmpds{k,nrun} = sdc;

            end
        end
    end

    linecolr = 'bgrcmyk';
%    plot_cols = plot_info.organize.plot_cols;
    for i = 1:numfigs
        fig_handle = figure('visible','off');
        clf
        cla
        hold on
        for nrun = 1:nruns
            for j = 1:length(fig_idx{i})
                plot(stp_data_time{fig_idx{i}(j),nrun}',stp_data_cmpds{fig_idx{i}(j),nrun},linecolr(mod(j-1,7)+1));
            end
        end
        hold off
        hleg = legend(plotcmpds{i});

        if this_matlab_version == 7;
            set(hleg, 'Interpreter','none');
        end
        
        if ssflag
            title_line1 = ['Number of Molecules vs. Time, showing snapshot data, for runs ' num2str(first_runid) ' through ' num2str(first_runid + nruns - 1)];
        else
            title_line1 = ['Number of Molecules vs. Time, showing every event, for runs ' num2str(first_runid) ' through ' num2str(first_runid + nruns - 1)];
        end

        title_line2 = ['source data file = ' data_partname];
        htitle = title({title_line1; title_line2});
        if this_matlab_version == 7;
            set(htitle, 'Interpreter','none');
        end
        
                figure(fig_handle);

        if savefigs
            figname = [data_partname '_fig' num2str(fig_handle) '.fig'];
            savefile = fullfile(analysis_dir,figname);
%            saveas(gcf,savefile);
             hgsave(gcf,savefile);  
        end
        
    end
    
    if use_batch == 0
        drawnow
    else
        filename = [data_partname '_figs_bnsan.mat'];
        savefile = fullfile(analysis_dir, filename);
        
        pstruc.plot_info = plot_info;
        pstruc.run_info = run_info;
        pstruc.dir_info = dir_info;
        pstruc.rxn_grp = rxn_grp;
        pstruc.timestart = timestart;
        pstruc.timeend = timeend;
        pstruc.data_partname = data_partname;
        pstruc.analysis_type = 'cmpds plot';

        save(savefile,'pstruc');

    end
    
end


