function plot_reaction_freq(pstruc)

[matlabversion,this_matlab_date] = version;
this_matlab_date = datenum(this_matlab_date);
matlab_700_date = datenum('July 1, 2003');
if this_matlab_date > matlab_700_date
    this_matlab_version = 7;
else
    this_matlab_version = 6;
end


plot_info = pstruc.plot_info;
run_info = pstruc.run_info;
dir_info = pstruc.dir_info;
rxn_grp = pstruc.rxn_grp;
create_barchart = pstruc.create_barchart;
plotrxns = pstruc.plotrxns;
rungrp = pstruc.rungrp;
firstrun = pstruc.firstrun;
lastrun = pstruc.lastrun;
timestart = pstruc.timestart;
timeend = pstruc.timeend;
agregated = pstruc.agregated;
parsed_partname = pstruc.parsed_partname;
data_partname = pstruc.data_partname;
create_eventplots = pstruc.create_eventplots;

if create_barchart
    avg_rnum = pstruc.avg_rnum;
    std_rnum = pstruc.std_rnum;
    rxn_names = pstruc.rxn_names;
    eventnum_matrix = pstruc.eventnum_matrix;
    
    figure
    bar(avg_rnum)
    hold on
    errorbar(avg_rnum,std_rnum,'LineStyle','none');
    hold off
    
    xlabel('Reaction name');
    ylabel('Number of reaction occurrences');
    
    set(gca,'xtick',[1:length(avg_rnum)]);
    set(gca, 'xticklabel', rxn_names);
    set(gca, 'FontSize', 7);
    title_line1 = ['Avg. and Std. of the number of times each reaction occurred.  Evaluated for runs ' num2str(firstrun) ' to ' num2str(lastrun)];
    title_line2 = ['time range = ' num2str(timestart) ' to ' num2str(timeend) '; source data file = ' parsed_partname];
    htitle = title({title_line1; title_line2});
    if this_matlab_version == 7;
        set(htitle, 'Interpreter','none');
    end
    
end

if length(plotrxns) ~= 0 && ~isempty(plotrxns{1})
    
    binnum = pstruc.binnum;
    bintime = pstruc.bintime;
    numfigs = pstruc.numfigs;
    fig_idx = pstruc.fig_idx;
    binsize = pstruc.binsize;
    if rungrp == 0 | rungrp == 1
        bin_avg = pstruc.bin_avg;
        bin_sd = pstruc.bin_sd;
    end
    
    linecolr = 'bgrcmyk';
    
    if rungrp == 0 | rungrp == 1
        
        for i = 1:numfigs
            fig_handle = figure('visible','off');
            clf
            cla
            hold on
            for j = 1:length(fig_idx{i})
                if rungrp == 0
                    errorbar(bintime,bin_avg(fig_idx{i}(j),:)', bin_sd(fig_idx{i}(j),:)','Color',linecolr(mod(j-1,7)+1));
                else
                    plot(bintime, bin_avg(fig_idx{i}(j),:)',linecolr(mod(j-1,7)+1));
                end
            end
            hold off

            xlabel('Time');
            ylabel('Number of reaction occurrences per time unit');
            
            hleg = legend(plotrxns{i});
            if this_matlab_version == 7;
                set(hleg, 'Interpreter','none');
            end

            set(gca, 'FontSize', 7);
            title_line1 = ['Binned Reaction occurences vs. time.  Evaluated for runs ' num2str(firstrun) ' to ' num2str(lastrun)];
            title_line2 = ['Bin Size = ' num2str(binsize) '.  Time range = ' num2str(timestart) ' to ' num2str(timeend) '.  Source data file = ' parsed_partname];
            htitle = title({title_line1; title_line2});
            if this_matlab_version == 7;
                set(htitle, 'Interpreter','none');
            end
            
            
            figure(fig_handle);
        end
            
    elseif rungrp == 2
        for i = 1:numfigs
            fig_handle = figure('visible','off');
            clf
            cla
            hold on
            for j = 1:length(fig_idx{i})
                for k = 1:size(binnum,1)
                    plot(bintime, squeeze(binnum(k,fig_idx{i}(j),:)),linecolr(mod(j-1,7)+1));
                end
            end
            hold off

            xlabel('Time');
            ylabel('Number of reaction occurrences per time unit');
            
            hleg = legend(plotrxns{i});
            if this_matlab_version == 7;
                set(hleg, 'Interpreter','none');
            end

            set(gca, 'FontSize', 7);
            title_line1 = ['Binned Reaction occurences vs. time.  Evaluated for runs ' num2str(firstrun) ' to ' num2str(lastrun)];
            title_line2 = ['Bin Size = ' num2str(binsize) '.  Time range = ' num2str(timestart) ' to ' num2str(timeend) '.  Source data file = ' parsed_partname];
            htitle = title({title_line1; title_line2});
            if this_matlab_version == 7;
                set(htitle, 'Interpreter','none');
            end
            
            figure(fig_handle);
        end
            
    elseif rungrp == 3
        runshowing = firstrun;
        for k = 1:min(30,size(binnum,1))
            for i = 1:numfigs
                fig_handle = figure('visible','off');
                clf
                cla
                hold on
                for j = 1:length(fig_idx{i})
                    plot(bintime, squeeze(binnum(k,fig_idx{i}(j),:)),linecolr(mod(j-1,7)+1));
                end
                hold off

                xlabel('Time');
                ylabel('Number of reaction occurrences per time unit');

                hleg = legend(plotrxns{i});
                if this_matlab_version == 7;
                    set(hleg, 'Interpreter','none');
                end

                set(gca, 'FontSize', 7);
                title_line1 = ['Binned Reaction occurences vs. time.  Evaluated for run ' num2str(runshowing)];
                title_line2 = ['Bin Size = ' num2str(binsize) '.  Time range = ' num2str(timestart) ' to ' num2str(timeend) '.  Source data file = ' parsed_partname];
                htitle = title({title_line1; title_line2});
                if this_matlab_version == 7;
                    set(htitle, 'Interpreter','none');
                end
                figure(fig_handle);
            end
            runshowing = runshowing + 1;
        end
    end
    
    if create_eventplots
        numrxns_list = pstruc.numrxns_list;
        bintimes = pstruc.bintimes;

        for i = 1:numrxns_list
            if ~isempty(bintimes(i).times)
                fig_handle = figure('visible','off');
                clf
                cla
                
                if (agregated == 0)
                    stem(bintimes(i).times,ones(length(bintimes(i).times),1),'Marker','none');
                else
                    stairs(bintimes(i).times, bintimes(i).agnum, 'Marker','none');
                end
                
                ylim([0 2]);
                xlabel('Time');
                ylabel('Reaction occurrence');

                hleg = legend(plotrxns{i});
                if this_matlab_version == 7;
                    set(hleg, 'Interpreter','none');
                end

                set(gca, 'FontSize', 7);
                title_line1 = ['Reaction event plot.  Every reaction event time is plotted.  Evaluated for run ' num2str(firstrun)];
                title_line2 = ['Time range = ' num2str(timestart) ' to ' num2str(timeend) '.  Source data file = ' parsed_partname];
                htitle = title({title_line1; title_line2});
                if this_matlab_version == 7;
                    set(htitle, 'Interpreter','none');
                end
                figure(fig_handle);
            end
        end
        
    end

end

drawnow

