function plot_sens(pstruc)

[matlabversion,this_matlab_date] = version;
this_matlab_date = datenum(this_matlab_date);
matlab_700_date = datenum('July 1, 2003');
if this_matlab_date > matlab_700_date
    this_matlab_version = 7;
else
    this_matlab_version = 6;
end


plot_info = pstruc.plot_info;
run_info = pstruc.run_info;
dir_info = pstruc.dir_info;
cmpd_info = pstruc.cmpd_info;
rxn_grp = pstruc.rxn_grp;
tw = pstruc.tw;
cmpdnames = pstruc.cmpdnames;
mean_tw = pstruc.mean_tw;
sens_mean = pstruc.sens_mean;
sens_std = pstruc.sens_std;
num_runs = pstruc.num_runs;
analysis = pstruc.analysis;
data_partname = pstruc.data_partname;
den = pstruc.den;
pertname = pstruc.pertname;
plothist = pstruc.plothist;
psetlist = pstruc.psetlist;


if plothist == 1;
    for j = 1:2
        for k = 1:length(cmpdnames{j})
            figure
            hist(tw{j}{k})

            xlabel('Number of molecules');
            ylabel('Number of runs');

            hleg = legend(cmpdnames{j}{k});
            if this_matlab_version == 7;
                set(hleg, 'Interpreter','none');
            end

            title_line1 = ['Frequency Histogram of Time-Weighted Average Number of Molecules -- ' num2str(num_runs) ' runs total'];
            title_line2 = ['time range = ' num2str(analysis.timestart) ' to ' num2str(analysis.timeend) '; source data file = ' data_partname '; paramset = ' num2str(psetlist(j))];
            htitle = title({title_line1; title_line2});
            if this_matlab_version == 7;
                set(htitle, 'Interpreter','none');
            end

        end
    end
end

figure
bar(sens_mean)
set(gca, 'xticklabel', cmpdnames{1});
set(gca, 'FontSize', 7);
title_line1 = ['Sensitivity of mean of each compound to ' num2str(den*100) '% variation in ' pertname];
title_line2 = ['time range = ' num2str(analysis.timestart) ' to ' num2str(analysis.timeend) '; source data file = ' data_partname];
htitle = title({title_line1; title_line2});
if this_matlab_version == 7;
    set(htitle, 'Interpreter','none');
end


figure
bar(sens_std)
set(gca, 'xticklabel', cmpdnames{1});
set(gca, 'FontSize', 7);
title_line1 = ['Sensitivity of standard deviation of each compound to ' num2str(den*100) '% variation in ' pertname];
title_line2 = ['time range = ' num2str(analysis.timestart) ' to ' num2str(analysis.timeend) '; source data file = ' data_partname];
htitle = title({title_line1; title_line2});
if this_matlab_version == 7;
    set(htitle, 'Interpreter','none');
end


drawnow
