function plot_twa(pstruc)

[matlabversion,this_matlab_date] = version;
this_matlab_date = datenum(this_matlab_date);
matlab_700_date = datenum('July 1, 2003');
if this_matlab_date > matlab_700_date
    this_matlab_version = 7;
else
    this_matlab_version = 6;
end


plot_info = pstruc.plot_info;
run_info = pstruc.run_info;
dir_info = pstruc.dir_info;
cmpd_info = pstruc.cmpd_info;
rxn_grp = pstruc.rxn_grp;
data_partname = pstruc.data_partname;
analysis1 = pstruc.analysis1;
create_histplot = pstruc.create_histplot;

rungrp = pstruc.rungrp;
firstrun = pstruc.firstrun;
lastrun = pstruc.lastrun;
timestart = pstruc.timestart;
timeend = pstruc.timeend;
plotcmpds = pstruc.plotcmpds;

%if length(analysis1.cmpd) ~= 0
if create_histplot
    tw_hist = pstruc.tw_hist;
    cmpdnames1 = pstruc.cmpdnames1;
%    mean_tw = pstruc.mean_tw;
%    std_tw = pstruc.std_tw;
%    num_runs = pstruc.num_runs;

    for k = 1:length(cmpdnames1)
        figure
%        hist(tw{k})
        hist(tw_hist(:,k))

        xlabel('Number of molecules');
        ylabel('Number of runs');

        hleg = legend(cmpdnames1{k});
        if this_matlab_version == 7;
            set(hleg, 'Interpreter','none');
        end

        title_line1 = ['Frequency Histogram of Time-Weighted Average Number of Molecules for runs ' num2str(firstrun) ' through ' num2str(lastrun)];
        title_line2 = ['time range = ' num2str(analysis1.timestart) ' to ' num2str(analysis1.timeend) '; source data file = ' data_partname];
        htitle = title({title_line1; title_line2});
        if this_matlab_version == 7;
            set(htitle, 'Interpreter','none');
        end

    end
    
end


tw = pstruc.tw;
bintime = pstruc.bintime;
numfigs = pstruc.numfigs;
fig_idx = pstruc.fig_idx;
binsize = pstruc.binsize;
if rungrp == 0 | rungrp == 1
    bin_avg = pstruc.bin_avg;
    bin_sd = pstruc.bin_sd;
end

linecolr = 'bgrcmyk';

if rungrp == 0 | rungrp == 1

    for i = 1:numfigs
        fig_handle = figure('visible','off');
        clf
        cla
        hold on
        for j = 1:length(fig_idx{i})
            if rungrp == 0
                 errorbar(bintime,bin_avg(fig_idx{i}(j),:)', bin_sd(fig_idx{i}(j),:)','Color',linecolr(mod(j-1,7)+1));
            else
                plot(bintime, bin_avg(fig_idx{i}(j),:)',linecolr(j));
            end
        end
        hold off

        xlabel('Time');
        ylabel('Compound number average');

        hleg = legend(plotcmpds{i});
       if this_matlab_version == 7;
            set(hleg, 'Interpreter','none');
        end

        set(gca, 'FontSize', 8);
        title_line1 = ['Binned Compound Numbers vs. Time.  Evaluated for runs ' num2str(firstrun) ' to ' num2str(lastrun)];
        title_line2 = ['Bin Size = ' num2str(binsize) '.  Time range = ' num2str(timestart) ' to ' num2str(timeend) '.  Source data file = ' data_partname];
        htitle = title({title_line1; title_line2});
        if this_matlab_version == 7;
            set(htitle, 'Interpreter','none');
        end


        figure(fig_handle);
    end

elseif rungrp == 2
    for i = 1:numfigs
        fig_handle = figure('visible','off');
        clf
        cla
        hold on
        for j = 1:length(fig_idx{i})
            for k = 1:size(tw,1)
                plot(bintime, squeeze(tw(k,fig_idx{i}(j),:)),linecolr(j));
            end
        end
        hold off

        xlabel('Time');
        ylabel('Compound number average');

        hleg = legend(plotcmpds{i});
        if this_matlab_version == 7;
            set(hleg, 'Interpreter','none');
        end

        set(gca, 'FontSize', 7);
        title_line1 = ['Binned Compound Numbers vs. Time.  Evaluated for runs ' num2str(firstrun) ' to ' num2str(lastrun)];
        title_line2 = ['Bin Size = ' num2str(binsize) '.  Time range = ' num2str(timestart) ' to ' num2str(timeend) '.  Source data file = ' data_partname];
        htitle = title({title_line1; title_line2});
        if this_matlab_version == 7;
            set(htitle, 'Interpreter','none');
        end

        figure(fig_handle);
    end

elseif rungrp == 3
    runshowing = firstrun;
    for k = 1:min(30,size(tw,1))
        for i = 1:numfigs
            fig_handle = figure('visible','off');
            clf
            cla
            hold on
            for j = 1:length(fig_idx{i})
                plot(bintime, squeeze(tw(k,fig_idx{i}(j),:)),linecolr(j));
            end
            hold off

            xlabel('Time');
            ylabel('Compound number average');

            hleg = legend(plotcmpds{i});
            if this_matlab_version == 7;
                set(hleg, 'Interpreter','none');
            end

            set(gca, 'FontSize', 7);
            title_line1 = ['Binned Compound Numbers vs. Time.  Evaluated for run ' num2str(runshowing)];
            title_line2 = ['Bin Size = ' num2str(binsize) '.  Time range = ' num2str(timestart) ' to ' num2str(timeend) '.  Source data file = ' data_partname];
            htitle = title({title_line1; title_line2});
            if this_matlab_version == 7;
                set(htitle, 'Interpreter','none');
            end
            figure(fig_handle);
        end
        runshowing = runshowing + 1;
    end
end

drawnow

