function [rxn_data, num_new, rxgp] = prepare_binding_rxn(rxn, rxgp, cmpd_name)

num_new = 0;
num_cmpds_on_left = length(rxn.lhs);
num_cmpds_on_right = length(rxn.rhs);

if num_cmpds_on_left == 2 && num_cmpds_on_right == 1
    rxn_dir = 1;    % binding goes l to r
elseif num_cmpds_on_right == 2 && num_cmpds_on_left == 1
    rxn_dir = 2;    % binding goes r to l
else
    error('A reaction with the "binding" type does not have 1 cmpd on one side and 2 on the other.')
end

if rxn_dir == 1

    if rxn.ltor.rate ~= 0
        num_new = num_new + 1;
        
        rxn_data{num_new}.name = rxn.name; 
        if strcmp(rxn.lhs{1,1},rxn.lhs{2,1})
            rxn_data{num_new}.type = 'homo-ltor';
        else
            rxn_data{num_new}.type = 'binding';
        end

        for i = 1:2
            rxgp = build_comps(rxn.lhs{i,1}, rxgp, cmpd_name);
            comp_id = find_comp_id(rxn.lhs{i,1},rxgp.comps);
            rxn_data{num_new}.substrates(i,1) = comp_id;

        end
        rxgp = build_comps(rxn.rhs{1,1}, rxgp, cmpd_name);
        comp_id = find_comp_id(rxn.rhs{1,1},rxgp.comps);
        rxn_data{num_new}.products(1,1) = comp_id;
        rxn_data{num_new}.StoP = rxn.ltor;
        rxn_data{num_new}.StoP_name{1} = [rxn_data{num_new}.name '.ltor.rate'];
    end

    if rxn.rtol.rate ~= 0
        num_new = num_new + 1;
        rxn_data{num_new}.name = rxn.name; 
        rxn_data{num_new}.type = 'unbinding';
        rxgp = build_comps(rxn.rhs{1,1}, rxgp, cmpd_name);
        comp_id = find_comp_id(rxn.rhs{1,1}, rxgp.comps);
        rxn_data{num_new}.substrates(1,1) = comp_id;
        for i = 1:2
            rxgp = build_comps(rxn.lhs{i,1}, rxgp, cmpd_name);
            comp_id = find_comp_id(rxn.lhs{i,1}, rxgp.comps);
            rxn_data{num_new}.products(i,1) = comp_id;
        end
        rxn_data{num_new}.StoP = rxn.rtol;
        rxn_data{num_new}.StoP_name{1} = [rxn_data{num_new}.name '.rtol.rate'];
    end
    
elseif rxn_dir == 2

    if rxn.rtol.rate ~= 0
        num_new = num_new + 1;
        
        rxn_data{num_new}.name = rxn.name; 
        if strcmp(rxn.rhs{1,1},rxn.rhs{2,1})
            rxn_data{num_new}.type = 'homo-ltor';
        else
            rxn_data{num_new}.type = 'binding';
        end
        
        for i = 1:2
            rxgp = build_comps(rxn.rhs{i,1}, rxgp, cmpd_name);
            comp_id = find_comp_id(rxn.rhs{i,1},rxgp.comps);
            rxn_data{num_new}.substrates(i,1) = comp_id;

        end
        rxgp = build_comps(rxn.lhs{1,1}, rxgp, cmpd_name);
        comp_id = find_comp_id(rxn.lhs{1,1},rxgp.comps);
        rxn_data{num_new}.products(1,1) = comp_id;
        rxn_data{num_new}.StoP = rxn.rtol;
        rxn_data{num_new}.StoP_name{1} = [rxn_data{num_new}.name '.rtol.rate'];
    end

    if rxn.ltor.rate ~= 0
        num_new = num_new + 1;
        rxn_data{num_new}.name = rxn.name; 
        rxn_data{num_new}.type = 'unbinding';
        rxgp = build_comps(rxn.lhs{1,1}, rxgp, cmpd_name);
        comp_id = find_comp_id(rxn.lhs{1,1}, rxgp.comps);
        rxn_data{num_new}.substrates(1,1) = comp_id;
        for i = 1:2
            rxgp = build_comps(rxn.rhs{i,1}, rxgp, cmpd_name);
            comp_id = find_comp_id(rxn.rhs{i,1}, rxgp.comps);
            rxn_data{num_new}.products(i,1) = comp_id;
        end
        rxn_data{num_new}.StoP = rxn.ltor;
        rxn_data{num_new}.StoP_name{1} = [rxn_data{num_new}.name '.ltor.rate'];
    end
end
    