function [modrxn, moddepend, mod_monitor] = prepare_matlab_indices_for_c(rxn,rxn_dependency_matrix, monitor_comps)

modrxn = rxn;
moddepend = rxn_dependency_matrix;

% need to fix up the difference between c 1st element (index of 0) and
% matlab first element (index of 1)
for i = 1:length(rxn)
    modrxn{i}.substrates(:,1) = rxn{i}.substrates(:,1) - 1;  
    if isfield(modrxn{i}, 'products')
        modrxn{i}.products(:,1) = rxn{i}.products(:,1) - 1;
    end
    
    moddepend{i} = rxn_dependency_matrix{i} - 1;
    modrxn{i}.id = i-1;
    
    if isfield(modrxn{i}, 'StoP')    
        modrxn{i} = rmfield(modrxn{i},'StoP');
    end

    modrxn{i}.StoP = rateparms_to_vector(rxn{i});

end

% also need to deal with indexing issue for compounds to monitor
if ~isempty(monitor_comps)
    for i = 1:length(monitor_comps)
        mod_monitor(i) = monitor_comps(i) - 1;
    end
else
    mod_monitor = [];
end

