function [rxn_data, num_new, rxgp] = prepare_nth_order_rxn(rxn, rxgp, cmpd_name)

%eval(['global ' filename])

%eval(['rxn = ' filename ';'])

num_new = 0;
if rxn.ltor.rate ~= 0
    num_new = num_new + 1;
    rxn_data{num_new}.type = 'n-order';
    rxn_data{num_new}.name = rxn.name;
    num_subs = size(rxn.lhs,1);
    sum_substr_orders = 0;
    for i = 1:num_subs
        sum_substr_orders = sum_substr_orders + rxn.lhs{i,3};
    end
    order_exp = rxn.ltor.order ./ sum_substr_orders;
    
    for i = 1:num_subs
        rxgp = build_comps(rxn.lhs{i,2}, rxgp, cmpd_name);
        comp_id = find_comp_id(rxn.lhs{i,2},rxgp.comps);
        rxn_data{num_new}.substrates(i,2) = rxn.lhs{i,1};
        rxn_data{num_new}.substrates(i,1) = comp_id;
        rxn_data{num_new}.substrates(i,3) = rxn.lhs{i,3} .* order_exp;
    end
    if isfield(rxn, 'rhs')
        num_prods = size(rxn.rhs,1);
        for i = 1:num_prods
            rxgp = build_comps(rxn.rhs{i,2}, rxgp, cmpd_name);
            comp_id = find_comp_id(rxn.rhs{i,2},rxgp.comps);
            rxn_data{num_new}.products(i,2) = rxn.rhs{i,1};
            rxn_data{num_new}.products(i,1) = comp_id;
        end
    end
    rxn_data{num_new}.StoP = rxn.ltor;
    rxn_data{num_new}.StoP_name{2} = [rxn_data{num_new}.name '.ltor.order'];
    rxn_data{num_new}.StoP_name{1} = [rxn_data{num_new}.name '.ltor.rate'];
 
end
    
if rxn.rtol.rate ~= 0
    num_new = num_new + 1;
    rxn_data{num_new}.type = 'n-order';
    rxn_data{num_new}.name = rxn.name;
    num_subs = size(rxn.rhs,1);
    sum_substr_orders = 0;
    for i = 1:num_subs
        sum_substr_orders = sum_substr_orders + rxn.rhs{i,3};
    end
    order_exp = rxn.rtol.order ./ sum_substr_orders;

    for i = 1:num_subs
        rxgp = build_comps(rxn.rhs{i,2}, rxgp, cmpd_name);
        comp_id = find_comp_id(rxn.rhs{i,2}, rxgp.comps);
        rxn_data{num_new}.substrates(i,2) = rxn.rhs{i,1};
        rxn_data{num_new}.substrates(i,1) = comp_id;
        rxn_data{num_new}.substrates(i,3) = rxn.rhs{i,3} .* order_exp;
    end
    num_prods = size(rxn.lhs,1);
    for i = 1:num_prods
        rxgp = build_comps(rxn.lhs{i,2}, rxgp, cmpd_name);
        comp_id = find_comp_id(rxn.lhs{i,2}, rxgp.comps);
        rxn_data{num_new}.products(i,2) = rxn.lhs{i,1};
        rxn_data{num_new}.products(i,1) = comp_id;
    end
    rxn_data{num_new}.StoP = rxn.rtol;
    rxn_data{num_new}.StoP_name{1} = [rxn_data{num_new}.name 'ltor.rate'];
    rxn_data{num_new}.StoP_name{2} = [rxn_data{num_new}.name 'ltor.order'];

end
