function [rxn_data, num_new, rxgp] = prepare_undef_rxn(rxn, rxgp, cmpd_name, vol)
%  Prepare reactions with Kinetic Law formula 
%       by Slava Chushak         
%       version 1.0 - 12/02/2005

num_new = 0;
%  Extract number of reactants and products

num_subs = size(rxn.lhs,1);
num_prods = size(rxn.rhs,1);

%  'formula' field should be defined !!! 

if isempty(rxn.ltor.rate.formula)
    error('A reaction without defined type must have defined KineticLaw formula.')
end

        num_new = num_new + 1;
        rxn_data{num_new}.type = 'undef';
        
%  Create a list of substrates

        for i = 1:num_subs
            rxgp = build_comps(rxn.lhs{i,2}, rxgp, cmpd_name);
            comp_id = find_comp_id(rxn.lhs{i,2},rxgp.comps);
            rxn_data{num_new}.substrates(i,1) = comp_id;
            rxn_data{num_new}.substrates(i,2) = rxn.lhs{i,1};
            rxn_data{num_new}.names{i} = rxn.lhs{i,2};

        end
        
        for i = 1:num_prods
            rxgp = build_comps(rxn.rhs{i,2}, rxgp, cmpd_name);
            comp_id = find_comp_id(rxn.rhs{i,2},rxgp.comps);
            rxn_data{num_new}.products(i,1) = comp_id;
            rxn_data{num_new}.products(i,2) = rxn.rhs{i,1};

        end

  const_names =  fieldnames(rxn.ltor.rate);    
  const_values = struct2cell(rxn.ltor.rate);
           n_kin_const = size(const_names,1)-1;
           if n_kin_const > 0
               for j = 1:n_kin_const
                    rxn_data{num_new}.StoP_name{j} = const_names{j,1};                 
                    rxn_data{num_new}.StoP(j) = const_values{j,1};
               end
           end
         

        rxn_data{num_new}.formula = rxn.ltor.rate.formula;