function rates_out = rateparms_to_vector(rxn)

% because the StoP field contains different subfields depending on
% reaction type, unfortunately I have to deal with these non-standardized fields

switch rxn.type
    case {'binding', 'unbinding','uni-uni','uni-multi', 'homo-ltor', 'transv1', 'unique-bi-bi'}
        rates_out = rxn.StoP.rate;
    case {'n-order'}
        rates_out = [rxn.StoP.rate rxn.StoP.order];
    case {'genmm'}
        rates_out(1) = rxn.StoP.k2;
        for j = 2:size(rxn.substrates,1)
            rates_out(j) = rxn.StoP.km(j-1);
        end
    case {'undef'}
        num_fields = size(rxn.StoP,2);
        n_rates = 0;
        rates_out = 0;
        for j = 1:num_fields
            val = rxn.StoP(j);
            if isnumeric(val)
                n_rates = n_rates + 1;
                rates_out(n_rates) = val;
            end
        end
        

end
    
