


clear tf;
clear cmpd_info

clear cmpd_list
clear num_cmpds
%clear orig_cmpd_vals

%cmpd_dir = fullfile(models_dir,specific_model_dir,parameters_dir,'initial_compound_numbers');
cmpd_dir = fullfile(param_dir,'initial_compound_numbers');


%%%%%%%% acquire list of files in compounds directory.  Should all be
%%%%%%%% m-files
cmpd_files = dir(cmpd_dir);

num_cmpd_files = size(cmpd_files,1);

num_cmpds = 0;

cd(cmpd_dir);       % because textread function reads from current directory


%%%%%% Create list of compound names from compounds named in the m-files stored in compounds directory.  
%%%%%% Store in cmpd_list (a list of ALL compounds that are not complexes).

for i = 1:num_cmpd_files

	if ~cmpd_files(i).isdir  
    
		tf = textread(cmpd_files(i).name,'%s','delimiter','\n','whitespace','');      % tf is short for temporary file
		
		for j = 1:size(tf,1)
            if ~isempty(tf{j}) & isempty(findstr(tf{j},'%'))
                num_cmpds = num_cmpds + 1;
                cmpd_list{num_cmpds} = strread(tf{j},'%s',1);     % scf means string cell file, each cell contains columns of cells
            end
		end
        
    end

end

cmpd_list = cmpd_list';

clear tf;


%%%%% Make all compounds in cmpd_list global

%for i = 1:num_cmpds
    
%    eval(['global ' cmpd_list{i}{1}]);
    
%end


%%%%%% Store parameter values (number of molecules, etc.) for each compound in cmpd_list.

for i = 1:num_cmpd_files
    
	if ~cmpd_files(i).isdir  
    
        mname = cmpd_files(i).name(1:end-2);        %strip off '.m' so can execute the m-file
        
        eval(mname);
        
    end
    
end

% store these initial compound values for use in multiple runs

num_newinitcmpds = length(thisset.newinitcmpds);

for i = 1:num_cmpds
    newval = 0;
    for j = 1:num_newinitcmpds
        if strcmp(thisset.newinitcmpds(j).name, cmpd_list{i}{1})
            cmpd_info.orig_cmpd_vals(i,1) = scaling_factor .* thisset.newinitcmpds(j).val;
%            eval(['cmpd_info.orig_cmpd_vals(i,1) = scaling_factor .* thisset.newinitcmpds(j).val;'])
            newval = 1;
            break;
        end
    end
    if ~newval
        eval(['cmpd_info.orig_cmpd_vals(i,1) = scaling_factor .* ' cmpd_list{i}{1} ';'])
    end
    cmpd_info.orig_cmpd_vals(i,2) = 0;
    cmpd_info.cmpd_name{i} = cmpd_list{i}{1};
%    cmpd_vals = orig_cmpd_vals;
end


cmpd_info.num_cmpds = num_cmpds;

for i = 1:length(plot_info.monitor_cmpds)
    for j = 1:num_cmpds
        if strcmp(plot_info.monitor_cmpds{i},cmpd_info.cmpd_name{j})
            plot_info.monitor_cmpds_gid(i) = j;
        end
    end
end



cd(code_dir);
