function evlog = read_logdata(file_name)

% Function reads a binary file with event_log data
% 1st argument = output directory (with full path)
% 2nd argument = batch name, from output_filename in default_directories.m
%                 Slava Chushak        02/07


if exist(file_name,'file')
   fid = fopen(file_name); 
else
    error( [file_name ' does not exist'])
end

A = fread(fid, 'double');
fclose(fid);

m=size(A,1)/2;
evlog(:,1) = A(1:m);
evlog(:,2) = A(m+1:2*m);