

%rxn_cons_dir = fullfile(models_dir,specific_model_dir,parameters_dir,'reaction_constants');
rxn_cons_dir = fullfile(param_dir,'reaction_constants');


%%%%%%%% acquire list of files in reaction_constants directory.  
rxn_cons_files = dir(rxn_cons_dir);

num_rxn_files = size(rxn_cons_files,1);

num_consts_rxns = 0;

rxns_with_params = zeros(num_rxns,1);

cd(rxn_cons_dir);       % because textread function reads from current directory


for i = 1:num_rxn_files

	if ~rxn_cons_files(i).isdir  
    
		tf = textread(rxn_cons_files(i).name,'%s','delimiter','\n','whitespace','');      % tf is short for temporary file
		
		for j = 1:size(tf,1)
            
            if ~isempty(tf{j}) & isempty(findstr(tf{j},'%'))
                rxnname = findstr(tf{j},'.rxn_grp');
                if ~isempty(rxnname)
                    num_consts_rxns = num_consts_rxns + 1;
                    rxn_const_list{num_consts_rxns} = strread(tf{j}(1:rxnname-1),'%s',1);     % grab the reaction name before '.rxn_grp'
	
					for krxns = 1:num_consts_rxns-1
                        if strcmp(rxn_const_list{krxns},rxn_const_list{num_consts_rxns})
                            warning(['Reaction ' rxn_const_list{krxns}{1} ' is defined twice in the reaction constants files.  Only the 2nd occurence in file ' rxn_cons_files(i).name ' will be used.'])
                            rxn_const_list(num_consts_rxns) = [];
                            num_consts_rxns = num_consts_rxns - 1;
                        end
					end
                    
                    rxn_exists = 0;
                    for krxns = 1:num_rxns
                        if strcmp(rxn_list{krxns},rxn_const_list{num_consts_rxns})
                            rxn_exists = 1;
                            rxns_with_params(krxns) = 1;
                            break
                        end
                    end
                    if rxn_exists == 0
                        error(['Reaction ' rxn_const_list{num_consts_rxns}{1} ' in the constants file ' rxn_cons_files(i).name ' does not have a corresponding reaction defined in the model.'])
                    end
                    
                end
            end
		end
        
        
        eval([rxn_cons_files(i).name(1:end-2)])
        
    end
    
end

if isfield(thisset,'newrateparms')
num_newrateparms = length(thisset.newrateparms);

for i = 1:num_newrateparms
    param_exists = 1;
    [s, srem] = strtok(thisset.newrateparms(i).name, '.');
    if ~exist(s)
        param_exists = 0;
    else
        while ~isempty(srem)
            [s2,srem] = strtok(srem,'.');
            eval(['tempstruc = ' s ';'])
            if ~isfield(tempstruc,s2)
                param_exists = 0;
                break;
            else
                s = [s '.' s2];
            end
        end
    end
    
    if param_exists
        eval([thisset.newrateparms(i).name ' = thisset.newrateparms(i).val;'])
    else
        warning([thisset.newrateparms(i).name ' is used in the current parameter set, but does not exist.'])
    end
end
end

no_const = find(rxns_with_params == 0);

if ~isempty(no_const)
    first_rxn = min(no_const);
    num_rxns_noconst = size(no_const,2);
    str_numrxns = int2str(num_rxns_noconst);
    error(['Reaction ' rxn_list{first_rxn}{1} ' does not have constants defined.  ' str_numrxns ' reactions in total do not have constants.'])
end


cd(code_dir);

