
%rxns_dir = fullfile(models_dir,specific_model_dir);

%%%%%%%% acquire list of reaction files in model directory.
rxn_files = dir(rxns_dir);

num_rxn_files = size(rxn_files,1);

num_rxns = 0;

cd(rxns_dir);       % because textread function reads from current directory

for i = 1:num_rxn_files        
	if ~rxn_files(i).isdir  
		tf = textread(rxn_files(i).name,'%s','delimiter','\n','whitespace','');      % tf is short for temporary file
		
		for j = 1:size(tf,1)
            
            if ~isempty(tf{j}) & isempty(findstr(tf{j},'%'))
                rxnname = findstr(tf{j},'.type');
                if ~isempty(rxnname)
                    num_rxns = num_rxns + 1;
                    rxn_list{num_rxns} = strread(tf{j}(1:rxnname-1),'%s',1);     % grab the reaction name before '.type'
					for krxns = 1:num_rxns-1
                        if strcmp(rxn_list{krxns},rxn_list{num_rxns})
                            warning(['Reaction ' rxn_list{num_rxns}{1} ' is defined twice.  Only the 2nd occurence in file ' rxn_files(i).name ' will be used.'])
                            rxn_list(num_rxns) = [];
                            num_rxns = num_rxns - 1;
                        end
					end
                   
                end
            end
		end
        
        
        eval([rxn_files(i).name(1:end-2)])
        
	end
    
end


cd(code_dir);
