function [data_time, data_cmpds, agr_event_log ] = read_snapshot(file_name)

% Function reads a text file with snapshotdata
% input argument = file's ID (file should be open with fopen)
% output argument = data_time and data_cmpds MATLAB arrays
%                 Slava Chushak        02/07
%         Modified by Slava Chushak 08/07 to read agregated event logs

if exist(file_name,'file')
   fid = fopen(file_name); 
else
    error( [file_name ' does not exist'])
end

data_time = [];
data_cmpds = [];
agr_event_log = []; 

set = fscanf(fid,'run %d points %d n_mon %d n_rxn %d\n',4);

for i=1:set(2)
      data_time(i) = fscanf(fid,'%g',1);
    for j=1:set(3)
      data_cmpds(i,j) = fscanf(fid,' %d',1);
    end
    for j=1:set(4)
      agr_event_log(i,j) =  fscanf(fid,' %d',1);
    end

        fscanf(fid,'\n');
end
fclose(fid);