function times_rxns_executed = read_timesexecuted(file_name,times_rxns_executed)

% Function reads a binary file with event_log data
% 1st argument = output directory (with full path)
% 2nd argument = batch name, from output_filename in default_directories.m
%                 Slava Chushak        02/07

if exist(file_name,'file')
   fid = fopen(file_name,'rt'); 
else
    error( [file_name ' does not exist'])
end

data = [];
while 1
  set1 = fscanf(fid, 'grp %d rxns %d\n', 2);
  if isempty(set1), break, end
  nrxns = set1(2);
  set2 = fscanf(fid, 'set %d run %d', 2);
  data = fscanf(fid,'%d %d\n', [2 nrxns]);
  times_rxns_executed{set1(1),set2(2)} = data(2,:);
end
fclose(fid);

