function save_snapshot(varargin)

% will create a single text file with name batch_name_snapshot
% containing number of snapshot for specific set
% and run number   
% in the same way as stand-alone version
%                   Modified   by     Slava Chushak      08/07

% 1st argument = file ID
% 2th argument = run_id
% 3th argument = data_times to be saved
% 4th argument = data_cmpds to be saved
% 5th argument = agregated event log data


fid = varargin{1};
times = varargin{3};
n_data = length(times);
cmpds = varargin{4};
n_mon = size(cmpds,2);

evlog = varargin{5};
n_rxn = size(evlog,2);

fprintf(fid,'run %d points %d n_mon %d n_rxn %d\n',varargin{2}, n_data, n_mon, n_rxn-1);

for i=1:n_data
        fprintf(fid,'%g',times(i));
    for j=1:n_mon
        fprintf(fid,'\t%d',cmpds(i,j));
    end
    for j=2:n_rxn
        fprintf(fid,'\t%d',evlog(i,j));
    end

        fprintf(fid,'\n');
end