%    Modified to work with SBML files    -    Slava Chushak    
% Look for *.xml files in the rxns_dir    
    file_list = dir(param_dir);
% If exist *.xml file, check whether it is an SBML model fiel    
    use_sbml = 0;   
    clear sbml_model
    for i = 1:size(file_list,1)
        file_name = file_list(i).name;
        if ~isempty(strfind(file_name,'.xml'))
            file_name = fullfile(param_dir,file_name);
            sbml_model = TranslateSBML(file_name);
            if isfield(sbml_model,'typecode')
                use_sbml = 1;
                break;
            end
        end
    end
    dir_info.use_sbml = use_sbml;
    
    if use_sbml ==1
        [rxn_grp, cmpd_info] = read_sbml_model(sbml_model);
        for i = 1:length(plot_info.monitor_cmpds)
            found_gid = 0;
             for j = 1:cmpd_info.num_cmpds
                 if strcmp(plot_info.monitor_cmpds{i},cmpd_info.cmpd_name{j})
                  plot_info.monitor_cmpds_gid(i) = j;
                  found_gid = 1;
                  break;
                 end
             end
         % Additional check for SBML Level2
             if (found_gid == 0) && (sbml_model.SBML_level == 2)
                 for j = 1:cmpd_info.num_cmpds
                    if strcmp(plot_info.monitor_cmpds{i},sbml_model.species(1,j).name)
                      plot_info.monitor_cmpds_gid(i) = j;
                      found_gid = 1;
                      break;
                    end
                 end
             end
             if found_gid == 0
                 error([ 'Cannot find gid for plot_info.monitor_cmpds - '  plot_info.monitor_cmpds{i}]);
             end
        end
        
        for i = 1:length(plot_info.monitor_cmpds_gid)
            rxn_grp{1}.monitor_comps(i) = find(plot_info.monitor_cmpds_gid(i) == rxn_grp{1}.global_comp_gid);
        end
        
num_rxns = length(rxn_grp{1}.rxn);
    
    end
