%function sens_calc(twa)

% used to analyze parsed eventlog files for parameter sets.


file_string = data_file;
%data_dir = twa.data_dir;
%analysis_dir = twa.analysis_dir;
%analysis_file = twa.analysis_file;
%param_set_num = str2num(twa.param_string);
psetlist = grplist;
%val1 = twa.val1;
%val2 = twa.val2;
%pertname = twa.pertname;
plothist = plotfreq;

analysis.cmpd = cmpds;
analysis.timestart = timestart;
analysis.timeend = timeend;

pf = findstr(file_string,'_parsed_1');
df = findstr(file_string,'_data_1');
if ~isempty(pf)
    name_core = file_string(1:pf(1)-1);
    datafile_core = [name_core '_data_*.mat'];
    ssflag = 0;
    data_partname = [name_core '_parsed'];
    rundata_file = [name_core '_rundata.mat'];
elseif ~isempty(df)
    name_core = file_string(1:df(1)-1);
    datafile_core = [name_core '_data_*.mat'];
    ssflag = 2;
    data_partname = [name_core '_data'];
    rundata_file = [name_core '_rundata.mat'];
end


datafilecore_wpath = fullfile(data_dir, datafile_core);

datafile_list = dir(datafilecore_wpath);
%num_datafiles = size(datafile_list,1);

%parsed_partname = [name_core '_parsed'];


%parsedfile_list = dir(fullfile(output_dir, [parsed_partname '*.mat']));
%num_parsedfiles = size(parsedfile_list,1);

if exist(fullfile(data_dir, rundata_file),'file')
    load(fullfile(data_dir, rundata_file), 'plot_info', 'run_info', 'dir_info', 'cmpd_info', 'rxn_grp')
else
    error([fullfile(data_dir, rundata_file) ' does not exist'])
end

tw = [];
cmpdnames = [];
mean_tw = [];
std_tw = [];
sens_mean = [];
sens_std = [];


pset = run_info.param_sets;

binsize = plot_info.snapshot_interval;

if ~isempty(pset)
    num_psets = length(pset);
    cur_runid = 1;
    for i = 1:num_psets
        pset(i).first_runid = cur_runid;
        cur_runid = cur_runid + pset(i).numruns;
    end
%    this_pset = pset(param_set_num);
%    num_runs = this_pset.numruns;
%    first_runid = this_pset.first_runid;
else
%    num_runs = run_info.num_runs;
%    first_runid = 1;
    error('No parameters sets found.  Sensitivity analysis only works with parameter sets.');
end


if length(analysis.cmpd) ~= 0
    for j = 1:2
        this_pset = pset(psetlist(j));
        num_runs = this_pset.numruns;
        first_runid = this_pset.first_runid;
        adatafilename_thispset = [name_core '_data_' num2str(first_runid) '.mat'];

        [t1, t2, t3, t4] = twui_ave(num_runs, first_runid, data_dir, data_partname, analysis, plot_info, ssflag, binsize);

        tw{j} = t1;
        cmpdnames{j} = t2;
        for k = 1:length(cmpdnames{j})
            mean_tw{j}(k) = mean(tw{j}(k));
            std_tw{j}(k) = std(tw{j}(k));
        end

    end

    for k = 1:length(cmpdnames{1})
        num = (mean_tw{2}(k) - mean_tw{1}(k)) ./ ((mean_tw{2}(k) + mean_tw{1}(k)) ./ 2);
    %    den = (analysis(i).sensitive_to.val(2) - analysis(i).sensitive_to.val(1)) ./ ((analysis(i).sensitive_to.val(2) + analysis(i).sensitive_to.val(1)) ./ 2);
        den = (val2 - val1) ./ ((val2 + val1) ./ 2);
        sens_mean(k) = num ./ den;
        num = (std_tw{2}(k) - std_tw{1}(k)) ./ ((std_tw{2}(k) + std_tw{1}(k)) ./ 2);
        sens_std(k) = num ./ den;
    end


    savefile = fullfile(analysis_dir, analysis_file);
    %save(savefile, 'tw', 'cmpdnames', 'mean_tw', 'std_tw', 'analysis', 'plot_info', 'run_info', 'dir_info', 'cmpd_info', 'rxn_grp');

    %savefile = fullfile(output_dir, [output_filename '_analysis_' num2str(i)]);
    pstruc.plot_info = plot_info;
    pstruc.run_info = run_info;
    pstruc.dir_info = dir_info;
    pstruc.cmpd_info = cmpd_info;
    pstruc.rxn_grp = rxn_grp;
    pstruc.tw = tw;
    pstruc.cmpdnames = cmpdnames;
    pstruc.mean_tw = mean_tw;
    pstruc.sens_mean = sens_mean;
    pstruc.sens_std = sens_std;
    pstruc.num_runs = num_runs;
    pstruc.analysis = analysis;
    pstruc.data_partname = data_partname;
    pstruc.den = den;
    pstruc.pertname = pertname;
    pstruc.plothist = plothist;
    pstruc.psetlist = psetlist;
    pstruc.analysis_type = 'sensitivity';
    

    
%    save(savefile, 'tw', 'cmpdnames', 'mean_tw', 'std_tw', 'sens_mean', 'sens_std', 'num_runs', 'analysis', 'data_partname', 'den', 'pertname', 'plot_info', 'run_info', 'dir_info', 'cmpd_info', 'rxn_grp');
    save(savefile,'pstruc');
    plot_sens(pstruc);

end


