function [cmpd_info, rxn_grp] = update_parameters(thisset, orig_cmpd_vals, num_cmpds, cmpd_info, scaling_factor, use_sbml, num_rxns, rxn_grp, StoP)

if isfield(thisset,'newinitcmpds')
    num_newinitcmpds = length(thisset.newinitcmpds);
    cmpd_info.orig_cmpd_vals = orig_cmpd_vals;        

    for i_cmpd = 1:num_cmpds
        for j_newval = 1:num_newinitcmpds
            if strcmp(thisset.newinitcmpds(j_newval).name, cmpd_info.cmpd_name(1,i_cmpd))
                cmpd_info.orig_cmpd_vals(i_cmpd,1) = scaling_factor .* thisset.newinitcmpds(j_newval).val;
            end
        end
    end
end

if isfield(thisset,'newrateparms')
    num_newrateparms = length(thisset.newrateparms);
    if use_sbml == 1 
    % Change all kinetic constants to initial
        for i_rxn = 1: num_rxns
           rxn = rxn_grp{1}.rxn{i_rxn};
           rxn.StoP = StoP{i_rxn};
           rxn_grp{1}.rxn{i_rxn} = rxn;
        end
        for i = 1:num_newrateparms
% Find and modify kinetic rate for SBML model
            for i_rxn = 1: num_rxns
                rxn = rxn_grp{1}.rxn{i_rxn};
                n_pars = length(rxn.StoP);
                if n_pars > 0
                    for j_rxn =1: n_pars
                        if strcmp(thisset.newrateparms(i).name,rxn.StoP_name{j_rxn})
                            rxn.StoP(j_rxn) = thisset.newrateparms(i).val;
                            rxn_grp{1}.rxn{i_rxn} = rxn;
                        end
                    end
                end
            end
        end
    end
end % newrateparms
