function write_analysis_parms(analysis_type,analysis_info)

% Save analysis parameters 
%  to run in batch mode
%            Created by Slava Chushak   18/2007

        fid = fopen('analysis_constants.m','wt');
  
        fprintf(fid, 'analysis_type=''%s'';\n',analysis_type);
        fprintf(fid, 'data_dir=''%s'';\n',analysis_info.data_dir);
        fprintf(fid, 'data_file=''%s'';\n',analysis_info.data_file);
        fprintf(fid, 'analysis_dir=''%s'';\n',analysis_info.analysis_dir);
        fprintf(fid, 'use_batch=%d;\n',analysis_info.use_batch);
      if isfield(analysis_info, 'analysis_file')        
        fprintf(fid, 'analysis_file=''%s'';\n',analysis_info.analysis_file);
      end
        fprintf(fid, 'timestart=%g;\n',analysis_info.timestart);
        fprintf(fid, 'timeend=%g;\n',analysis_info.timeend);
      if isfield(analysis_info, 'param_string')        
        fprintf(fid, 'param_string=''%s'';\n',analysis_info.param_string);
      end
      if isfield(analysis_info, 'firstrun')        
        fprintf(fid, 'firstrun=%d;\n',analysis_info.firstrun);
      end
      if isfield(analysis_info, 'lastrun')        
        fprintf(fid, 'lastrun=%d;\n',analysis_info.lastrun);
      end
      if isfield(analysis_info, 'binsize')        
        fprintf(fid, 'binsize=%g;\n',analysis_info.binsize);
      end
      if isfield(analysis_info, 'rungrp')        
        fprintf(fid, 'rungrp=%d;\n',analysis_info.rungrp);
      end
      if isfield(analysis_info, 'rxngrp')        
        fprintf(fid, 'rxngrp=%d;\n',analysis_info.rxngrp);
      end
      if isfield(analysis_info, 'cmpdgrp')        
        fprintf(fid, 'cmpdgrp=%d;\n',analysis_info.cmpdgrp);
      end
      if isfield(analysis_info, 'create_histplots')        
        fprintf(fid, 'create_histplot=%d;\n',analysis_info.create_histplots);
      end
      if isfield(analysis_info, 'create_barchart')        
        fprintf(fid, 'create_barchart=%d;\n',analysis_info.create_barchart);
      end
      if isfield(analysis_info, 'rungrp')        
        fprintf(fid, 'rungrp=%d;\n',analysis_info.rungrp);
      end
      if isfield(analysis_info, 'create_eventplots')        
        fprintf(fid, 'create_eventplots=%d;\n',analysis_info.create_eventplots);
      end
      if isfield(analysis_info, 'savefigs')        
        fprintf(fid, 'savefigs=%d;\n',analysis_info.savefigs);
      end
      if isfield(analysis_info, 'plotfreq')        
        fprintf(fid, 'plotfreq=%d;\n',analysis_info.plotfreq);
      end
      if isfield(analysis_info, 'plotcmpds')        
          n_to_plot = size(analysis_info.plotcmpds,2);
          if (n_to_plot == 1) && isempty(analysis_info.plotcmpds{1})
            fprintf(fid,'plotcmpds = [];');
          else
          % Save new list_to_plot
                for i=1:n_to_plot
                    rem = analysis_info.plotcmpds{i};      
                   if isempty(rem)
                       break;
                   end
                     fprintf(fid,'plotcmpds{%d} = {',i);
                     for j=1:size(rem,1)
                         fprintf(fid,'''%s'' ',rem{j,1});
                     end 
                     fprintf(fid,'};\n');
                end               
          end
      end
      if isfield(analysis_info, 'val1')        
        fprintf(fid, 'val1=%g;\n',analysis_info.val1);
      end
      if isfield(analysis_info, 'val2')        
        fprintf(fid, 'val2=%g;\n',analysis_info.val2);
      end
      if isfield(analysis_info, 'pertname')        
        fprintf(fid, 'pertname=''%s'';\n',analysis_info.pertname);
      end
       if isfield(analysis_info, 'cmpds')        
          n_to_plot = size(analysis_info.cmpds,1);
          % Save new list_to_plot
               
                     fprintf(fid,'cmpds= {');
                  for i=1:n_to_plot 
                         fprintf(fid,'''%s'' ',analysis_info.cmpds{i,1});
                  end 
                     fprintf(fid,'};\n');       
       end
     
       if isfield(analysis_info, 'grplist')        
        
                     fprintf(fid,'grplist = [');
                  for i=1:2
                         fprintf(fid,'%d ' ,analysis_info.grplist(1,i));
                  end 
                     fprintf(fid,'];\n');       
       end
     
    fclose(fid);
