function write_bns_textfile(modrxn, cmpd_nums, mod_monitor, run_info, plot_info, dir_info, numsets)

%  Modified by Slava Chushak   11/2006

volume = run_info.volume;
time_start = run_info.time_start;
time_end = run_info.time_end;
stoch_algor = run_info.stoch_algor;
randseed = run_info.randseed;
num_repeats = run_info.num_runs;
eventlog_flag = plot_info.eventlog_flag;
snapshot_interval = plot_info.snapshot_interval;
output_filename = dir_info.output_filename;
use_sbml = dir_info.use_sbml;

constants_filename = [output_filename '_constants.txt'];

        snapshot_filename = [output_filename '_data'];
        rundata_filename = [output_filename '_timesexecuted'];
        evlog_filename = [output_filename '_eventlog'];
        
        fid = fopen('constants.txt','wt');
        fprintf(fid, '%s\n',dir_info.output_dir);
        fprintf(fid, '%s\n', constants_filename);
        fclose(fid);
        fid = fopen(constants_filename,'wt');
        fprintf(fid,'%s\n', snapshot_filename);
        fprintf(fid,'%s\n', rundata_filename);
        fprintf(fid,'%s\n\n', evlog_filename);
        
        fprintf(fid,'num_sets = %d\n',numsets);
        num_rxns = length(modrxn);
        fprintf(fid,'num_rxns = %d\n',num_rxns);
        num_cmpds = length(cmpd_nums.name);
        fprintf(fid,'num_cmpds = %d\n\n',num_cmpds);
        
 %  Write species
        for i = 1:num_cmpds

           fprintf(fid,'%s %d\n',cmpd_nums.name{i},cmpd_nums.value(i,1));
        end
        fprintf(fid,'\n');
%  Write reactions
        for i = 1:length(modrxn)
            mr = modrxn{i};
            fprintf(fid,'rxn = %s\n',mr.name);
            fprintf(fid,'rxntype = %s\n',mr.type);
            num_subs = size(mr.substrates,1);
            fprintf(fid,'num_subs = %d\n',num_subs);
            for j = 1:num_subs
                for k = 1:min([2,size(mr.substrates,2)])
                    fprintf(fid,' %d',mr.substrates(j,k));
                end
                if size(mr.substrates,2) == 3
                    fprintf(fid,' %e',mr.substrates(j,3));
                end
                fprintf(fid,'\n');
            end
    %            fprintf(fid,'\n');
            if isfield(mr,'products')
                num_prods = size(mr.products,1);
                fprintf(fid,'num_prods = %d\n',num_prods);
                for j = 1:num_prods
                    for k = 1:size(mr.products,2)
                        fprintf(fid,' %d',mr.products(j,k));
                    end
                    fprintf(fid,'\n');
                end
            else
                fprintf(fid,'num_prods = 0\n');
            end
         if strcmp(mr.type,'undef')
             formula = strrep(mr.formula, ' ', '');
             fprintf(fid,'%s\n',formula);
             n_rates = length(mr.StoP);
             fprintf(fid,'num_rates %d\n',n_rates);
             for j = 1:n_rates
                fprintf(fid,'%s %e\n',mr.StoP_name{j},mr.StoP(j));
             end
         else
            fprintf(fid,'StoP = ');
                for j = 1:length(mr.StoP)
                fprintf(fid,'%e ',mr.StoP(j));
                end
            fprintf(fid,'\n');
         end
            
            fprintf(fid,'id = %d\n\n',mr.id);
        end

        fprintf(fid,'time_start = %e\n',time_start);
        fprintf(fid,'time_end = %e\n',time_end);
        fprintf(fid,'volume = %e\n',volume);
        fprintf(fid,'algorithm = %d\n',stoch_algor);
    if (stoch_algor ==3)
        if isfield(run_info,'tau_error')
            fprintf(fid,'tau_error = %f \n',run_info.tau_error);
        else
            fprintf(fid,'tau_error = 0.1; \n');
        end
    end
            
        fprintf(fid,'randseed = %u\n\n', randseed);

        num_monit = length(mod_monitor);
        fprintf(fid,'num_monit = %d\n',num_monit);
        for i = 1:num_monit
            fprintf(fid,'%d\n',mod_monitor(i));
        end
        fprintf(fid,'\n');

        fprintf(fid,'snapshot_interval = %e\n',snapshot_interval);
        fprintf(fid,'eventlog_flag = %d\n',eventlog_flag);

    if (numsets > 1)
        thisset = run_info.param_sets(1);
         if isfield(thisset, 'numruns')
             num_repeats = thisset.numruns;
         end
    end
        fprintf(fid,'num_repeats = %d\n\n',num_repeats);
        
    if (numsets > 1)    
      for i_setnum = 2:numsets 
         thisset = run_info.param_sets(i_setnum);
% Check for number of runs. If dosn'e exist - use the old one.
         if isfield(thisset, 'numruns')
             num_repeats = thisset.numruns;
         end
         fprintf(fid,'num_repeats = %d\n',num_repeats);
% Check for the modified compounds                
         if isfield(thisset,'newinitcmpds')
            num_newinitcmpds = length(thisset.newinitcmpds);
            fprintf(fid,'num_species = %d\n',num_newinitcmpds);  

               for j_new = 1:num_newinitcmpds
                mol_id = find_comp_id(thisset.newinitcmpds(j_new).name,cmpd_nums.name);   
                fprintf(fid,'%d %d\n',(mol_id-1),thisset.newinitcmpds(j_new).val);    
               end
         else
            fprintf(fid,'num_species = 0\n');
         end
% Check for the modified parameters  
        if isfield(thisset,'newrateparms')
            num_newrateparms = length(thisset.newrateparms);
            fprintf(fid,'num_rates = %d\n',num_newrateparms);  
            
            for j_new = 1:num_newrateparms
              new_name = thisset.newrateparms(j_new).name;
              for i_rxn = 1: num_rxns
                mr = modrxn{i_rxn};
                if strcmp(mr.type,'undef')
                 n_pars = length(mr.StoP);
                  if n_pars > 0
                    for j_rxn =1: n_pars
                        StoP_name = mr.StoP_name{j_rxn};
                        if strcmp(new_name,StoP_name)
                            fprintf(fid,'%d %d %g\n',(i_rxn-1),(j_rxn-1),thisset.newrateparms(j_new).val);
                            break;
                        end
                    end
                  end
                else
                n_pars = length(mr.StoP);
                  if n_pars > 0
                    for j_rxn =1: n_pars
                        if strcmp(new_name,mr.StoP_name{j_rxn})
                            fprintf(fid,'%d %d %g\n',(i_rxn-1),(j_rxn-1),thisset.newrateparms(j_new).val);
                            break;
                        end
                    end
                  end 
                end
              end  
            end
        end
        fprintf(fid,'\n');
      end
    end
    fclose(fid);
